<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductsByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method getProductBySkuCodeByParams(array $params)
 * @method getSkuPromotionListBySkuIdsByParams(array $params)
 * @method getUserInfoByParams(array $params)
 * @method getStockBySkuIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取商品
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @support  string $name 名称 require false
     * @support  string $skuCode sku编码 require false
     * @support  array $categoryIds 品类ids require false
     * @param  uint $page 当前页 [ require true ]
     * @param  uint $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProducts (array $storeIds, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProducts([
            "storeIds" => $storeIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取品类树
     *
     * @param  int $parentId 父级id [ require true ]
     * @param  int $depth 深度,代表几级分类 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryTree (int $parentId = 0, int $depth = 0, bool $showDeleted = false) {
        return self::getClass()->getCategoryTree([
            "parentId" => $parentId,
            "depth" => $depth,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 扫码获取商品
     *
     * @param  string $skuCode sku编码/更多编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductBySkuCode (string $skuCode) {
        return self::getClass()->getProductBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * 根据skuids获取促销活动信息
     *
     * @param  array $skuIds skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuPromotionListBySkuIds (array $skuIds) {
        return self::getClass()->getSkuPromotionListBySkuIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 根据手机号获取用户信息
     *
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo (string $phone) {
        return self::getClass()->getUserInfo([
            "phone" => $phone,
        ]);
    }

    /**
     * 根据门店id和skuIds获取对应的库存
     *
     * @param  array $skuIds skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockBySkuIds (array $skuIds) {
        return self::getClass()->getStockBySkuIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Retail\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Retail\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}