<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method detailByParams(array $params)
 * @method allByParams(array $params)
 * @method payByParams(array $params)
 */
class SubscribeCardPackageOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加卡包订单
     *
     * @support  string $order_no 一销订单号 require false
     * @support  string $name 客户名称 require false
     * @support  string $phone 手机号 require false
     * @support  string $birthday 日期 require false
     * @support  int $package_id 订阅卡包 id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 卡包订单详情
     *
     * @support  string $package_order_no 卡包订单编号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 卡包订单列表
     *
     * @support  array $created_at 购买时间: [start, end] require false
     * @support  string $name 客户名字 require false
     * @support  string $phone 客户手机号 require false
     * @support  int $page 分页页码 require false
     * @support  int $page_size 分页大小 require false
     * @support  string $status 订单状态 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 确认支付
     *
     * @support  int $id 卡包订单ID require false
     * @support  string $payment_type 支付类型 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function pay () {
        return self::getClass()->pay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\SubscribeCardPackageOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\SubscribeCardPackageOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}