<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method repealReceiptProductByParams(array $params)
 * @method listByParams(array $params)
 * @method getReceiptInfoByParams(array $params)
 * @method getReceiptProductListByParams(array $params)
 */
class StoreReceipt {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加收货信息
     *
     * @support  int $storeId 门店id require false
     * @support  int $staffId 工号 require false
     * @support  string $note 备注 require false
     * @support  array $receiptProducts 发货信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 撤销收货信息
     *
     * @param  int $id 发货商品id [ require true ]
     * @param  int $storeReceiptId 收货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function repealReceiptProduct (int $id, int $storeReceiptId) {
        return self::getClass()->repealReceiptProduct([
            "id" => $id,
            "storeReceiptId" => $storeReceiptId,
        ]);
    }

    /**
     * 获取发货单列表
     *
     * @support  int $storeId 部门id require false
     * @support  int $staffId 员工工号 require false
     * @support  string $createTimeStart 开始时间 require false
     * @support  string $createTimeEnd 结束时间 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页记录数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取收货单基本信息
     *
     * @param  int $id 发货id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReceiptInfo (int $id) {
        return self::getClass()->getReceiptInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取收货单商品列表
     *
     * @support  int $id 发货id require false
     * @support  int $storeId 门店id require false
     * @support  string $productName 产品名 require false
     * @support  string $skuCode sku编码 require false
     * @support  string $status 状态 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页记录数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getReceiptProductList () {
        return self::getClass()->getReceiptProductList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\StoreReceipt');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\StoreReceipt');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}