<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method latestByParams(array $params)
 */
class PreferenceInfo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加偏好信息
     *
     * @support  int $id 订单ID require false
     * @support  string $from 来源 require false
     * @support  array $items 多条偏好信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 根据订单号获取偏好信息列表
     *
     * @support  int $id 订单ID require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 更新偏好信息
     *
     * @support  int $id 订单偏好信息ID(不是订单ID) require false
     * @support  string $nickname 宝贝昵称 require false
     * @support  string $birthday 宝贝生日 require false
     * @support  int $height 宝贝身高:参考PreferenceHeightEnum require false
     * @support  int $sex 性别:0-男宝宝;1-女宝宝 require false
     * @support  string $hobby 爱好 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除偏好信息
     *
     * @support  int $id 订单偏好信息ID(不是订单ID) require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 获取最新偏好信息
     *
     * @support  int $id 订单ID require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function latest () {
        return self::getClass()->latest();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\PreferenceInfo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\PreferenceInfo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}