<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getOrderPhoneByParams(array $params)
 * @method verifyOrderByParams(array $params)
 * @method verifyOrderGiftByParams(array $params)
 * @method detailByNumByParams(array $params)
 * @method changeAddressByParams(array $params)
 * @method createByParams(array $params)
 * @method getParamsBeforeCreateOrderByParams(array $params)
 * @method userReachedByParams(array $params)
 * @method modifyUserReachedByParams(array $params)
 * @method setUserReachedPaidByParams(array $params)
 * @method getUserReachedDetailByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method updateUserByParams(array $params)
 * @method cancelByParams(array $params)
 * @method paidByParams(array $params)
 * @method retailOrderSetPaidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method finishByParams(array $params)
 * @method orderServiceCompletedByParams(array $params)
 * @method getOrderGiftByParams(array $params)
 * @method getOrderWorkloadsByParams(array $params)
 * @method setOrderWorkloadsByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method removeByParams(array $params)
 * @method getCanUseCouponListByParams(array $params)
 * @method getCanUseProductCardListByParams(array $params)
 * @method jxjyCouponByParams(array $params)
 * @method getCouponInfoByParams(array $params)
 * @method getProductCardInfoByParams(array $params)
 * @method calCouponDeductionInfoByParams(array $params)
 * @method calProductDeductionInfoByParams(array $params)
 * @method calInteriorCouponDeductionInfoByParams(array $params)
 * @method workloadsByParams(array $params)
 * @method checkUserSubscribeByParams(array $params)
 * @method getEncryptOrderNumByParams(array $params)
 * @method getShortUrlByParams(array $params)
 * @method sendPayLinkByParams(array $params)
 * @method resetByParams(array $params)
 * @method workloadDetailByParams(array $params)
 * @method reserveProductCountByParams(array $params)
 * @method getProductDiscountByIdsByParams(array $params)
 * @method operateLogByParams(array $params)
 * @method createPayMaxPaymentByParams(array $params)
 * @method payMaxCallbackByParams(array $params)
 * @method callBackTestByParams(array $params)
 * @method getOrderClothByParams(array $params)
 * @method itemsCheckByParams(array $params)
 * @method clearAutoFinishPhotoByParams(array $params)
 * @method prepareByParams(array $params)
 * @method createPaymentByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 * @method cancelLookPhotoReserveTimeByParams(array $params)
 * @method batchLookingPhotoNumbersAndTimesByParams(array $params)
 * @method getLookingPhotoExtendInfoByParams(array $params)
 * @method getLookingPhotoNumbersByParams(array $params)
 * @method bigOrderByParams(array $params)
 * @method productDingByParams(array $params)
 * @method useGiftCardMoneyByParams(array $params)
 * @method useMarketCardMoneyByParams(array $params)
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method listByPayByParams(array $params)
 * @method getWxQrCodeByParams(array $params)
 * @method getPrintInfoByParams(array $params)
 * @method autoSendCouponUseMeituanDianpingByParams(array $params)
 * @method canRefundRetailProductByParams(array $params)
 * @method canDeliveryRetailProductByParams(array $params)
 * @method getOrderEditStatusByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表查询
     *
     * @support  string $orderNo 订单号 require false
     * @support  string $reserveTimeStart 预约开始时间 require false
     * @support  string $reserveTimeEnd 预约结束时间 require false
     * @support  string $createTimeStart 查询开始时间 require false
     * @support  string $createTimeEnd 查询结束时间 require false
     * @support  string $status 订单状态 require false
     * @support  string $statusList 订单状态 require false
     * @support  string $userName 下单用户 require false
     * @support  string $userPhone 手机号 require false
     * @support  int $userId 用户id require false
     * @support  bool $allStore 是否查询所有门店 require false
     * @support  bool $isHangUp 是否查询挂起订单 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @support  string $sortField 排序字段 require false
     * @support  bool $sortDesc 是否倒序 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $orderNo 订单号 [ require true ]
     * @support  bool $orderPhoneDesensitization 订单手机号是否脱敏 require false
     * @support  bool $withDelete 是否包含删除 require false
     * @support  bool $withRefund 是否包含退款 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取订单手机号
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  bool $desensitization 是否脱敏,true=脱敏隐藏中间四位｜false=不脱敏 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderPhone (int $orderId, bool $desensitization) {
        return self::getClass()->getOrderPhone([
            "orderId" => $orderId,
            "desensitization" => $desensitization,
        ]);
    }

    /**
     * 核销订单
     *
     * @support  int $order_id 订单号 [ require true ]
     * @support  string $activity_type 核销活动类型 require false
     * @support  string $type 核销产品类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function verifyOrder () {
        return self::getClass()->verifyOrder();
    }

    /**
     * 核销订单赠品
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $order_verification_id 订单核销id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function verifyOrderGift () {
        return self::getClass()->verifyOrderGift();
    }

    /**
     * 通过订单号获取订单详情
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  bool $with_del 是否包含删除 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByNum () {
        return self::getClass()->detailByNum();
    }

    /**
     * 修改外拍订单地址
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $outsideCity 拍摄城市 [ require true ]
     * @support  string $outsideAddress 拍摄地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeAddress () {
        return self::getClass()->changeAddress();
    }

    /**
     * 创建订单
     *
     * @support  int $userId 用户ID require false
     * @support  string $userName 用户名 require false
     * @support  string $userPhone 用户手机号 require false
     * @support  string $userSex 用户性别 require false
     * @support  string $userBirthday 用户生日 require false
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 订单实际金额(做校验用) require false
     * @support  array $productInfo 订单详情 require false
     * @support  int $reachedPeopleNum 实际到店人数 require false
     * @support  string $interiorCouponCode 开单折扣码UUID require false
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 require false
     * @support  int $couponId 优惠券ID require false
     * @support  float $couponDeductionMoney 优惠券抵扣金额 require false
     * @support  int $productCardId 产品卡ID require false
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 require false
     * @support  float $specialDiscountMoney 特殊折扣金额 require false
     * @support  string $discountType 特殊折扣类型 require false
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id require false
     * @support  string $reserveTime 预约时间 require false
     * @support  array $groupOrderItemIds 团购产品 require false
     * @support  array $retailProducts 零售产品数组 require false
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 require false
     * @support  string $outsideCity 外拍订单城市 require false
     * @support  string $outsideAddress 外拍地址 require false
     * @support  array $packageDiscountIds 套餐优惠信息 require false
     * @support  float $packageDiscountMoney 套餐优惠金额 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取创建订单中间参数
     *
     * @support  int $userId 用户ID require false
     * @support  string $userName 用户名 require false
     * @support  string $userPhone 用户手机号 require false
     * @support  string $userSex 用户性别 require false
     * @support  string $userBirthday 用户生日 require false
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 订单实际金额(做校验用) require false
     * @support  array $productInfo 订单详情 require false
     * @support  int $reachedPeopleNum 实际到店人数 require false
     * @support  string $interiorCouponCode 开单折扣码UUID require false
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 require false
     * @support  int $couponId 优惠券ID require false
     * @support  float $couponDeductionMoney 优惠券抵扣金额 require false
     * @support  int $productCardId 产品卡ID require false
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 require false
     * @support  float $specialDiscountMoney 特殊折扣金额 require false
     * @support  string $discountType 特殊折扣类型 require false
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id require false
     * @support  string $reserveTime 预约时间 require false
     * @support  string $type 订单类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getParamsBeforeCreateOrder () {
        return self::getClass()->getParamsBeforeCreateOrder();
    }

    /**
     * 设置拍摄订单签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $reachedPeopleNum 签到人数 [ require true ]
     * @support  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @support  float $money 签到补收金额（如果不需要补收，可以为空） require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function userReached () {
        return self::getClass()->userReached();
    }

    /**
     * 修改拍摄订单签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $reachedPeopleNum 签到人数 [ require true ]
     * @support  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @support  float $money 签到补收金额（如果不需要补收，可以为空） require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyUserReached () {
        return self::getClass()->modifyUserReached();
    }

    /**
     * 设置签到完成支付
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  string $paymentNo 支付流水号 require false
     * @support  int $operateId 录单人 require false
     * @support  bool $fromPaymentGateway 来自支付网关 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserReachedPaid () {
        return self::getClass()->setUserReachedPaid();
    }

    /**
     * 如果没有数据，说明没有支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserReachedDetail (int $orderId) {
        return self::getClass()->getUserReachedDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUser (int $id, int $user_id) {
        return self::getClass()->bindUser([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 取消绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 修改订单所属用户
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  string $phone 新绑定用户的手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUser () {
        return self::getClass()->updateUser();
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId orderDiffId [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号【管理端非必填】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paid (int $id, int $orderDiffId, string $payType, string $paymentNo = '') {
        return self::getClass()->paid([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 零售完成支付（用于支付链接支付）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号【管理端非必填】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retailOrderSetPaid (int $id, string $payType, string $paymentNo = '') {
        return self::getClass()->retailOrderSetPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单（拍摄完成）
     *
     * @param  int $id 订单ID [ require true ]
     * @support  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function finish (int $id) {
        return self::getClass()->finish([
            "id" => $id,
        ]);
    }

    /**
     * 订单服务完成
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderServiceCompleted (int $orderId) {
        return self::getClass()->orderServiceCompleted([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询订单赠品
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderGift (int $orderId) {
        return self::getClass()->getOrderGift([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询订单工作量
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderWorkloads () {
        return self::getClass()->getOrderWorkloads();
    }

    /**
     * 录入工作量
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderWorkloads () {
        return self::getClass()->setOrderWorkloads();
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_sex 用户姓名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 删除订单
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 用户可用优惠券列表
     *
     * @support  array $product_group_ids 产品组ids require false
     * @support  array $product_ids 产品ids [ require true ]
     * @support  array $service_product_ids 服务ids require false
     * @support  int $user_id 用户ID [ require true ]
     * @support  int $order_id 订单id(用于查找当前订单已用券) require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanUseCouponList () {
        return self::getClass()->getCanUseCouponList();
    }

    /**
     * 用户可用产品卡列表
     *
     * @support  array $product_group_ids 产品组ids require false
     * @support  array $product_ids 产品ids [ require true ]
     * @support  array $service_product_ids 服务ids require false
     * @support  int $user_id 用户ID [ require true ]
     * @support  int $order_id 订单id(用于查找当前订单已用券) require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanUseProductCardList () {
        return self::getClass()->getCanUseProductCardList();
    }

    /**
     * 获取用户加修加印券
     *
     * @support  int $user_id 用户id require false
     * @support  array $product_group_ids 产品组ids require false
     * @support  array $product_ids 产品ids [ require true ]
     * @support  int $order_id 订单id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function jxjyCoupon () {
        return self::getClass()->jxjyCoupon();
    }

    /**
     * 获取优惠券详情
     *
     * @param  int $id 优惠券id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponInfo (int $id) {
        return self::getClass()->getCouponInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品券详情
     *
     * @param  int $id 产品券id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCardInfo (int $id) {
        return self::getClass()->getProductCardInfo([
            "id" => $id,
        ]);
    }

    /**
     * 计算优惠券可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $coupon_id 优惠券ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calCouponDeductionInfo () {
        return self::getClass()->calCouponDeductionInfo();
    }

    /**
     * 计算产品卡可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $product_card_id 产品卡ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calProductDeductionInfo () {
        return self::getClass()->calProductDeductionInfo();
    }

    /**
     * 订单开单折扣码抵扣
     *
     * @support  string $interior_coupon_code 开单折扣码 [ require true ]
     * @support  bool $verify_usability 验证可用性 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function calInteriorCouponDeductionInfo () {
        return self::getClass()->calInteriorCouponDeductionInfo();
    }

    /**
     * 录入工作量
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $workloads 工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workloads () {
        return self::getClass()->workloads();
    }

    /**
     * 检查订单用户是否关注公众号
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserSubscribe (int $user_id) {
        return self::getClass()->checkUserSubscribe([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取加密订单号
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEncryptOrderNum (string $order_num) {
        return self::getClass()->getEncryptOrderNum([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 获取短链接
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $url 付款链接前缀 [ require true ]
     * @param  string $pay_type 类型(首款或者尾款) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShortUrl (string $order_num, string $url, string $pay_type = '') {
        return self::getClass()->getShortUrl([
            "order_num" => $order_num,
            "url" => $url,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 发送付款链接
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $url 付款链接 [ require true ]
     * @param  string $phone 电话号码 [ require true ]
     * @param  string $orderType 订单类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPayLink (int $orderId, string $url, string $orderType, string $phone) {
        return self::getClass()->sendPayLink([
            "orderId" => $orderId,
            "url" => $url,
            "orderType" => $orderType,
            "phone" => $phone,
        ]);
    }

    /**
     * 重置工作量
     *
     * @support  int $order_id 订单ID [ require true ]
     * @support  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reset () {
        return self::getClass()->reset();
    }

    /**
     * 工作量查询
     *
     * @support  string $order_num 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workloadDetail () {
        return self::getClass()->workloadDetail();
    }

    /**
     * 获取当日售卖产品总数
     *
     * @support  string $reserveTimeStart 起始时间 require false
     * @support  string $reserveTimeEnd 结束时间 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function reserveProductCount () {
        return self::getClass()->reserveProductCount();
    }

    /**
     * 折扣列表
     *
     * @support  string $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountByIds () {
        return self::getClass()->getProductDiscountByIds();
    }

    /**
     * 管理端查询订单操作记录
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operateLog (int $order_id) {
        return self::getClass()->operateLog([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 创建拉卡拉线下支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [ require true ]
     * @support  array $extend 扩展字段 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPayMaxPayment () {
        return self::getClass()->createPayMaxPayment();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payMaxCallback () {
        return self::getClass()->payMaxCallback();
    }

    /**
     * WARN 测试环境使用
     *
     * @param  array $data 测试数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callBackTest (array $data) {
        return self::getClass()->callBackTest([
            "data" => $data,
        ]);
    }

    /**
     * 获取订单选衣信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderCloth (int $order_id) {
        return self::getClass()->getOrderCloth([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 门店新增子订单处理选衣
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $item_ids 子订单itemids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemsCheck (int $order_id, array $item_ids) {
        return self::getClass()->itemsCheck([
            "order_id" => $order_id,
            "item_ids" => $item_ids,
        ]);
    }

    /**
     * 清除自动看片完成订单的顾客满意片
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearAutoFinishPhoto (int $order_id) {
        return self::getClass()->clearAutoFinishPhoto([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 校验美团大众券信息
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function prepare (string $receipt_code, int $store_id) {
        return self::getClass()->prepare([
            "receipt_code" => $receipt_code,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 创建美团大众点评支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [ require true ]
     * @support  string $receipt_code 核销码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPayment () {
        return self::getClass()->createPayment();
    }

    /**
     * 修改看片预约时间
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $look_photo_reserve_time 看片预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeLookPhotoReserveTime (int $order_id, string $look_photo_reserve_time) {
        return self::getClass()->changeLookPhotoReserveTime([
            "order_id" => $order_id,
            "look_photo_reserve_time" => $look_photo_reserve_time,
        ]);
    }

    /**
     * 取消看片预约
     *
     * @param  int $order_id 订单id [ require true ]
     * @support  string $look_photo_reserve_time 取消预约时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelLookPhotoReserveTime (int $order_id) {
        return self::getClass()->cancelLookPhotoReserveTime([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 批量获取看片照片数量和时长
     *
     * @param  array $order_ids 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchLookingPhotoNumbersAndTimes (array $order_ids) {
        return self::getClass()->batchLookingPhotoNumbersAndTimes([
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * 获取看片照片数量,时长,看片通知时间 - bms
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLookingPhotoExtendInfo (int $order_id) {
        return self::getClass()->getLookingPhotoExtendInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取看片照片数量
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLookingPhotoNumbers (int $order_id) {
        return self::getClass()->getLookingPhotoNumbers([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 是否是大订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bigOrder (int $order_id) {
        return self::getClass()->bigOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 特殊产品ding门店伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDing () {
        return self::getClass()->productDing();
    }

    /**
     * 修改使用礼品卡金额
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $giftCardPayMoney 礼品卡金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useGiftCardMoney () {
        return self::getClass()->useGiftCardMoney();
    }

    /**
     * 修改使用商场卡金额
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $marketCardMoney 商场卡金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useMarketCardMoney () {
        return self::getClass()->useMarketCardMoney();
    }

    /**
     * 使用礼品卡支付确认的推送
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardMoney 礼品卡支付金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return self::getClass()->sendGiftCardPayDsConfirmPush([
            "id" => $id,
            "giftCardMoney" => $giftCardMoney,
        ]);
    }

    /**
     * 查账助手-根据订单类型获取
     *
     * @support  string $orderType 订单类型 require false
     * @support  string $type 子订单类型：order,ds require false
     * @support  string $status 状态 require false
     * @support  string $statusList 状态列表 require false
     * @support  string $payType 支付类型，同子订单支付类型 require false
     * @support  string $paidAtStart 支付时间起始 [ require true ]
     * @support  string $paidAtEnd 支付时间结束 [ require true ]
     * @support  string $pageSize  require false
     * @support  string $page  require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function listByPay () {
        return self::getClass()->listByPay();
    }

    /**
     * 获取临时二维码
     *
     * @support  string $key 二维码key值 [ require true ]
     * @support  string $expireSeconds 过期时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWxQrCode () {
        return self::getClass()->getWxQrCode();
    }

    /**
     * 获取打印订单信息
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPrintInfo () {
        return self::getClass()->getPrintInfo();
    }

    /**
     * 美团点评订单签到时发券
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function autoSendCouponUseMeituanDianping (int $orderId, int $userId) {
        return self::getClass()->autoSendCouponUseMeituanDianping([
            "orderId" => $orderId,
            "userId" => $userId,
        ]);
    }

    /**
     * 是否可以退零售产品
     *
     * @param  int $orderId 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundRetailProduct (int $orderId) {
        return self::getClass()->canRefundRetailProduct([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 零售是否可以提货
     *
     * @param  int $orderId 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canDeliveryRetailProduct (int $orderId) {
        return self::getClass()->canDeliveryRetailProduct([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取订单正在编辑的状态
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderEditStatus (int $orderId) {
        return self::getClass()->getOrderEditStatus([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}