<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getStaffInfoByIdsByParams(array $params)
 * @method storeStaffByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取员工列表
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $store_id) {
        return self::getClass()->list([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 通过员工id获取信息
     *
     * @param  array $staffIds 员工id [ require true ]
     * @param  string $includeLeaveDate 过滤离职日期晚于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoByIds (array $staffIds, string $includeLeaveDate = '') {
        return self::getClass()->getStaffInfoByIds([
            "staffIds" => $staffIds,
            "includeLeaveDate" => $includeLeaveDate,
        ]);
    }

    /**
     * 根据分类获取门店成员列表
     *
     * @support  int $store_id 门店ID require false
     * @support  string $staff_type 伙伴职位Alias require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeStaff () {
        return self::getClass()->storeStaff();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}