<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookStreamPhotoMetaTagByParams(array $params)
 * @method urgentStreamByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hook流水－图片七牛云标签
     *
     * @param  string $streamNum 流水num [ require true ]
     * @param  array $photos 照片组 [ require true ]
     * @param  array $photoMeta photoMeta [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamPhotoMetaTag (string $streamNum, array $photos, array $photoMeta = []) {
        return self::getClass()->hookStreamPhotoMetaTag([
            "streamNum" => $streamNum,
            "photos" => $photos,
            "photoMeta" => $photoMeta,
        ]);
    }

    /**
     * 加急流水
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  int $userId 用户id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgentStream () {
        return self::getClass()->urgentStream();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}