<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getDetailByCodeByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品详情
     *
     * @param  uint $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 产品分页列表
     *
     * @support  int $page 当前页 require false
     * @support  int $page_size 页内条数 require false
     * @support  string $name 名称(模糊查询) require false
     * @support  uint $category_id 品类ID require false
     * @support  string $status 产品状态 require false
     * @support  bool $show_deleted 是否显示已删除信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) require false
     * @support  uint $category_id 品类ID require false
     * @support  string $status 产品状态 require false
     * @support  bool $show_deleted 是否显示已删除信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 查询零售产品列表
     *
     * @support  int $store_id 门店id require false
     * @support  array $sku_ids sku_ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList () {
        return self::getClass()->getProductList();
    }

    /**
     * 通过产品编码获取产品详情
     *
     * @param  string $sku_code 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailByCode (string $sku_code) {
        return self::getClass()->getDetailByCode([
            "sku_code" => $sku_code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Retail\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Retail\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}