<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMaterialNamesByCodeByParams(array $params)
 * @method getMaterialsByNameByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getMaterialNamesByCode
     *
     * @support  array $code 物料编码 
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialNamesByCode () {
        return self::getClass()->getMaterialNamesByCode();
    }

    /**
     * getMaterialsByName
     *
     * @param  string $name 物料名称 [ require true ]
     * @support  int $isFixedAsset 是否固定资产,1是0否无全部 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialsByName (string $name) {
        return self::getClass()->getMaterialsByName([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}