<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method reverseRepairingPhotoByParams(array $params)
 * @method submitByParams(array $params)
 * @method cancelByParams(array $params)
 * @method removeByParams(array $params)
 * @method closePaidByParams(array $params)
 * @method paidByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method modifyMoneyByParams(array $params)
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method useMarketCardMoneyByParams(array $params)
 * @method doNotUseGiftCardMoneyByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method getSubOrderItemUpgradeByParams(array $params)
 * @method getTempSubOrderByParams(array $params)
 * @method listByPayByParams(array $params)
 */
class SubOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 子订单列表
     *
     * @support  string $type 订单类型：order,ds 
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $status 状态 
     * @support  string $status_list 状态 
     * @support  string $paid_at_start 支付时间起始 [ require true ]
     * @support  string $paid_at_end 支付时间结束 [ require true ]
     * @support  string $page_size  
     * @support  string $page  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 子订单详情
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $mode 打印模式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $mode = '') {
        return self::getClass()->detail([
            "id" => $id,
            "mode" => $mode,
        ]);
    }

    /**
     * 创建子订单【只能创建二销】
     *
     * @support  int $order_id 主订单ID [ require true ]
     * @support  string $ds_type 二销类型 [ require true ]
     * @support  array $detail 子订单详情【子订单包含的产品&amp;服务】 [ require true ]
     * @support  float $gift_card_money 礼品卡抵扣金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  float $coupon_deduction_money 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $product_card_id 产品卡ID 
     * @support  string $interior_coupon_code 开单折扣码 
     * @support  int $input_staff_id 录入伙伴ID [ require true ]
     * @support  float $product_card_deduction_money 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $product_discount_ids 组合优惠id 
     * @support  float $product_discount_deduction_money 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $upgrade_id 升级体验父级项id 
     * @support  string $discount_scene 改价选项 
     * @support  int $partner_no 伙伴工号（伙伴改价场景需要） 
     * @support  float $input_real_money 手动输入的实际价格（改价时需要） [Original type double] 
     * @support  string $create_mode 订单创建模式 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 回滚看片
     *
     * @param  int $orderId 主订单ID [ require true ]
     * @param  string $reserveTime 订单预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reverseRepairingPhoto (int $orderId, string $reserveTime = '') {
        return self::getClass()->reverseRepairingPhoto([
            "orderId" => $orderId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 提交子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 取消子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @param  string $application_type 使用场景 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason, string $application_type = '') {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
            "application_type" => $application_type,
        ]);
    }

    /**
     * 删除子订单
     *
     * @support  int $id 子订单ID [ require true ]
     * @support  string $application_type 使用场景 
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 关闭已支付二销
     *
     * @support  int $id 子订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePaid () {
        return self::getClass()->closePaid();
    }

    /**
     * 子订单完成支付
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paid (int $id, string $pay_type, string $payment_no = '') {
        return self::getClass()->paid([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 修改支付方式
     *
     * @support  int $id 修改支付方式 [ require true ]
     * @support  string $pay_type 支付方式 
     * @support  string $pay_no 流水号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType () {
        return self::getClass()->changePayType();
    }

    /**
     * 改价格
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $real_money 支付金额 [Original type double] [ require true ]
     * @param  float $gift_card_money 礼品卡金额 [Original type double] [ require true ]
     * @param  string $partner_no 伙伴工号 [ require true ]
     * @param  string $options 改价选项 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyMoney (int $id, string $options, float $real_money = NULL, float $gift_card_money = NULL, string $partner_no = NULL) {
        return self::getClass()->modifyMoney([
            "id" => $id,
            "options" => $options,
            "real_money" => $real_money,
            "gift_card_money" => $gift_card_money,
            "partner_no" => $partner_no,
        ]);
    }

    /**
     * 发送二销使用礼品卡支付确认的推送
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $gift_card_money 礼品卡支付金额 [Original type unsignedDouble] 
     * @support  string $mode 模式（灰度兼容老版本，mode为new的时候才执行新逻辑） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush () {
        return self::getClass()->sendGiftCardPayDsConfirmPush();
    }

    /**
     * 商场卡支付金额
     *
     * @support  int $id 订单id(子订单) [ require true ]
     * @support  float $market_card_money 商场卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useMarketCardMoney () {
        return self::getClass()->useMarketCardMoney();
    }

    /**
     * 不使用礼品卡
     *
     * @support  int $id 子订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function doNotUseGiftCardMoney () {
        return self::getClass()->doNotUseGiftCardMoney();
    }

    /**
     * 折扣列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountList () {
        return self::getClass()->getProductDiscountList();
    }

    /**
     * 获取子订单产品升级服务
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubOrderItemUpgrade () {
        return self::getClass()->getSubOrderItemUpgrade();
    }

    /**
     * 订单子项
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTempSubOrder (int $order_id) {
        return self::getClass()->getTempSubOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 子订单列表-根据订单类型获取
     *
     * @support  string $order_type 订单类型 
     * @support  string $type 子订单类型：order,ds 
     * @support  string $status 状态 
     * @support  string $status_list 状态列表 
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $paid_at_start 支付时间起始 [ require true ]
     * @support  string $paid_at_end 支付时间结束 [ require true ]
     * @support  string $page_size  
     * @support  string $page  
     * @throws  \Exception
     * @return  mixed
     */
    public static function listByPay () {
        return self::getClass()->listByPay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\SubOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\SubOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}