<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method detailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method createUpgradeSkuByParams(array $params)
 */
class OrderDiff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个订单修改(订单完成前)
     *
     * @support  int $orderId 订单ID 
     * @support  int $userId 用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实际金额(做校验用) [Original type double] [ require true ]
     * @support  float $needPaidMoney 订单待支付金额 [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  int $reachedPeopleNum 实际到店人数 [ require true ]
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 
     * @support  string $module 模块 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 设置diff订单完成支付
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  string $paymentNo 支付流水号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid () {
        return self::getClass()->setPaid();
    }

    /**
     * 获取diff详情
     *
     * @support  int $orderDiffId 订单diff的ID [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @support  bool $showCancel 是否显示取消的修改信息（会显示最新一个取消的修改信息) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 取消未支付订单
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $reason 取消原因(取消修改和重新编辑) [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 完成订单之后添加加修加印产品
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  array $productInfo 订单详情(无需完成前的订单信息) [ require true ]
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  int $inputStaffId 伙伴id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createUpgradeSku () {
        return self::getClass()->createUpgradeSku();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\OrderDiff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\OrderDiff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}