<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getNeedInventoryCheckSkuByParams(array $params)
 * @method submitByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 */
class RetailInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取需要库存盘点的零售物料信息
     *
     * @support  int $categoryId 分类 [Original type uint] 
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNeedInventoryCheckSku (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getNeedInventoryCheckSku([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 提交盘点结果
     *
     * @support  int $id 盘点记录id [Original type uint] 
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  array $materialInfo 物料信息 [ require true ]
     * @param  string $applyIn 总部/门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $staffId, array $materialInfo, string $applyIn = 'store') {
        return self::getClass()->submit([
            "staffId" => $staffId,
            "materialInfo" => $materialInfo,
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * 盘点列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $staffId 操作人 
     * @support  string $applyIn 总部/门店 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点详情
     *
     * @param  int $inventoryId 盘点记录id [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\RetailInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\RetailInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}