<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 */
class RetailCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品品类
     *
     * @param  string $name 品类名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name) {
        return self::getClass()->create([
            "name" => $name,
        ]);
    }

    /**
     * 编辑零售产品品类
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @param  string $name 品类名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $name) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 批量编辑零售产品品类
     *
     * @param  array $data 品类数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 品类详情
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除品类
     *
     * @param  int $id 品类ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 品类分页列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 品类列表
     * @deprecated
     *
     * @param  bool $show_deleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (bool $show_deleted = false) {
        return self::getClass()->all([
            "show_deleted" => $show_deleted,
        ]);
    }

    /**
     * 添加品类时获取类目N级树状列表/获取树状列表
     *
     * @param  bool $withProducts 是否带产品信息 [ require true ]
     * @param  int $parentId 父级id [ require true ]
     * @param  int $depth 深度,代表几级分类 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryTree (bool $withProducts = true, int $parentId = 0, int $depth = 0, bool $showDeleted = false) {
        return self::getClass()->getCategoryTree([
            "withProducts" => $withProducts,
            "parentId" => $parentId,
            "depth" => $depth,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Retail\RetailCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Retail\RetailCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}