<?php
namespace Mainto\Bridge\Invokes\HimoProductStore;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method qtAvailableTakersByParams(array $params)
 * @method queryStoresByParams(array $params)
 * @method getProductClothByParams(array $params)
 * @method updateOrderClothByParams(array $params)
 * @method getOrderGuestsNumByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门市客服服务通关的伙伴id
     *
     * @param  array $staff_ids 伙伴ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function qtAvailableTakers (array $staff_ids) {
        return self::getClass()->qtAvailableTakers([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * [管]门店列表
     *
     * @param  string $classification_nums 区域id;用,隔开 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStores (string $classification_nums = '') {
        return self::getClass()->queryStores([
            "classification_nums" => $classification_nums,
        ]);
    }

    /**
     * 获取门店产品可选衣服
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCloth (int $store_id, int $product_id) {
        return self::getClass()->getProductCloth([
            "store_id" => $store_id,
            "product_id" => $product_id,
        ]);
    }

    /**
     * 更新订单服装
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $items 各产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateOrderCloth (int $order_id, array $items) {
        return self::getClass()->updateOrderCloth([
            "order_id" => $order_id,
            "items" => $items,
        ]);
    }

    /**
     * 获取产品人数
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $item_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderGuestsNum () {
        return self::getClass()->getOrderGuestsNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}