<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPassProductIdsByParams(array $params)
 * @method getOrdersCallRecordByParams(array $params)
 * @method getUserLabelByIdByParams(array $params)
 * @method getConsumerPreferencesByIdByParams(array $params)
 * @method getAssetSituationByIdByParams(array $params)
 * @method getHistoryOrderPageByIdByParams(array $params)
 * @method getUserInfoByParams(array $params)
 * @method getUserCouponsByParams(array $params)
 * @method getUserUnverifiedGiftBoxByParams(array $params)
 * @method getUserWaitingWelfaresByParams(array $params)
 */
class Paperless {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴已通关产品id列表
     *
     * @support  array $staffIds 伙伴id列表 
     * @throws  \Exception
     * @return  array
     */
    public static function getPassProductIds () {
        return self::getClass()->getPassProductIds();
    }

    /**
     * 获取订单的致电记录
     *
     * @support  array $orderIds 订单id列表 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrdersCallRecord () {
        return self::getClass()->getOrdersCallRecord();
    }

    /**
     * 获取指定会员的标签数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserLabelById () {
        return self::getClass()->getUserLabelById();
    }

    /**
     * 获取指定会员的消费偏好
     *
     * @support  int $userId 会员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getConsumerPreferencesById () {
        return self::getClass()->getConsumerPreferencesById();
    }

    /**
     * 获取指定会员的资产情况
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAssetSituationById () {
        return self::getClass()->getAssetSituationById();
    }

    /**
     * 获取指定会员的历史订单数据
     *
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryOrderPageById () {
        return self::getClass()->getHistoryOrderPageById();
    }

    /**
     * 获取用户基本信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 获取用户优惠券
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserCoupons () {
        return self::getClass()->getUserCoupons();
    }

    /**
     * 获取用户待提货产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserUnverifiedGiftBox () {
        return self::getClass()->getUserUnverifiedGiftBox();
    }

    /**
     * 获取用户待领取权益
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserWaitingWelfares () {
        return self::getClass()->getUserWaitingWelfares();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\Paperless');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\Paperless');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}