<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserLabelByIdByParams(array $params)
 * @method getConsumerPreferencesByIdByParams(array $params)
 * @method getAssetSituationByIdByParams(array $params)
 * @method getHistoryOrderPageByIdByParams(array $params)
 * @method getUnverifiedGiftBoxByParams(array $params)
 * @method getWaitingWelfaresByParams(array $params)
 * @method getUserByPhoneByParams(array $params)
 * @method getUserByIdByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取指定会员的标签数据
     *
     * @support  int $userId 会员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserLabelById () {
        return self::getClass()->getUserLabelById();
    }

    /**
     * 获取指定会员的消费偏好
     *
     * @support  int $userId 会员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getConsumerPreferencesById () {
        return self::getClass()->getConsumerPreferencesById();
    }

    /**
     * 获取指定会员的资产情况
     *
     * @support  int $userId 会员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAssetSituationById () {
        return self::getClass()->getAssetSituationById();
    }

    /**
     * 获取指定会员的历史订单数据
     *
     * @support  int $userId 会员ID [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryOrderPageById () {
        return self::getClass()->getHistoryOrderPageById();
    }

    /**
     * 获取用户待提货产品
     *
     * @support  int $userId 会员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUnverifiedGiftBox () {
        return self::getClass()->getUnverifiedGiftBox();
    }

    /**
     * 获取用户待领取权益
     *
     * @support  int $userId 会员ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWaitingWelfares () {
        return self::getClass()->getWaitingWelfares();
    }

    /**
     * 注意：隐含了创建...没有用户就自动注册一个
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $applyIn 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserByPhone (string $phone, string $applyIn = 'himo') {
        return self::getClass()->getUserByPhone([
            "phone" => $phone,
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * 注意：隐含了创建...没有用户就自动注册一个
     * TODO 该接口被其它场景用到后，重构支持选择是否加载优惠信息
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserById (int $user_id) {
        return self::getClass()->getUserById([
            "user_id" => $user_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}