<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method getTempSubOrderByParams(array $params)
 */
class SubOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送二销使用礼品卡支付确认的推送
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $gift_card_money 礼品卡支付金额 [Original type unsignedDouble] 
     * @support  string $mode 模式（灰度兼容老版本，mode为new的时候才执行新逻辑） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush () {
        return self::getClass()->sendGiftCardPayDsConfirmPush();
    }

    /**
     * 折扣列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountList () {
        return self::getClass()->getProductDiscountList();
    }

    /**
     * 订单子项
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTempSubOrder (int $order_id) {
        return self::getClass()->getTempSubOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\SubOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\SubOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}