<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method paidByParams(array $params)
 * @method cancelByParams(array $params)
 * @method reviewByParams(array $params)
 * @method balanceEntryByParams(array $params)
 * @method getPhotoOrdersByParams(array $params)
 * @method getProductCardOrdersByParams(array $params)
 * @method deleteOrderItemByParams(array $params)
 * @method sendEmailTestByParams(array $params)
 * @method reviewCallbackByParams(array $params)
 * @method reviewOrderByParams(array $params)
 * @method getStoresByTypeByParams(array $params)
 * @method getPriceAreaStoreByParams(array $params)
 * @method getAvailableProductsByParams(array $params)
 * @method drawCodeByParams(array $params)
 * @method exportProductCardCodesByParams(array $params)
 * @method getPhoneByParams(array $params)
 * @method handleGroupOrderByParams(array $params)
 * @method getListByPayByParams(array $params)
 */
class GroupOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 团购订单列表
     *
     * @support  string $business_name 企业名称 
     * @support  string $type 产品类型/券码类型 
     * @support  string $user_name 联系人 
     * @support  string $user_phone 手机号 
     * @support  array $order_ids 订单ids 
     * @support  string $order_no 订单号 
     * @support  string $status 订单状态 
     * @support  int $is_private_pay 是否垫付(-1:非垫付，1：垫付) 
     * @support  int $is_installment 是否分期(-1:全款，1：分期) 
     * @support  string $installment_status 分期付款状态 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 创建订单
     *
     * @support  string $business_name 企业名称 [ require true ]
     * @support  string $user_name 联系人 [ require true ]
     * @support  string $user_phone 手机号 [ require true ]
     * @support  string $email 联系人邮箱 
     * @support  array $detail 团购产品信息/券码信息 
     * @support  string $type 券码类型/产品类型 
     * @support  string $note 预约信息备注 
     * @support  bool $is_installment 是否分期 
     * @support  bool $is_private_pay 是否垫付（私人付款） 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $pay_money 实付金额 [Original type double] 
     * @support  float $discount 折扣 [Original type double] 
     * @support  float $down_payment_money 首付金额 [Original type double] 
     * @support  float $balance_payment_money 尾款金额 [Original type double] 
     * @support  string $private_user_name 垫付人姓名 
     * @support  string $private_user_phone 垫付人电话 
     * @support  string $group_internal_contact 内部联系人 
     * @support  float $outside_shot_money 外拍金额 [Original type double] 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $group_order_type 券码类型/产品类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $group_order_type = '') {
        return self::getClass()->detail([
            "id" => $id,
            "group_order_type" => $group_order_type,
        ]);
    }

    /**
     * 订单支付（全款与首款）
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $paid_at 打款时间 [ require true ]
     * @support  float $money 金额+外拍金额 [Original type double] [ require true ]
     * @support  string $payment_no 支付流水号 
     * @support  array $certificates 支付凭证 
     * @support  string $type 付款类型（全款，首款，尾款） [ require true ]
     * @support  string $group_order_type 券码类型/产品类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function paid () {
        return self::getClass()->paid();
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id) {
        return self::getClass()->cancel([
            "id" => $id,
        ]);
    }

    /**
     * 订单审核
     * @deprecated
     *
     * @param  int $pay_id 支付id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function review (int $pay_id) {
        return self::getClass()->review([
            "pay_id" => $pay_id,
        ]);
    }

    /**
     * 支付尾款
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  string $paid_at 打款时间 [ require true ]
     * @support  float $money 尾款金额 [Original type double] [ require true ]
     * @support  string $payment_no 支付流水号 
     * @support  bool $is_change 尾款是否变动 
     * @support  array $detail 变动详情 
     * @support  array $certificates 支付凭证 
     * @support  string $group_order_type 券码类型/产品类型 
     * @throws  \Exception
     * @return  array
     */
    public static function balanceEntry () {
        return self::getClass()->balanceEntry();
    }

    /**
     * 获取关联拍摄订单
     *
     * @support  int $group_order_id 团购订单id [ require true ]
     * @support  string $order_no 订单ids 
     * @support  string $user_name 下单用户 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoOrders () {
        return self::getClass()->getPhotoOrders();
    }

    /**
     * 获取券码关联订单
     *
     * @support  int $group_order_id 团购订单id [ require true ]
     * @support  string $user_name 姓名 
     * @support  string $user_phone 手机号 
     * @support  string $himo_order_no 订单号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCardOrders () {
        return self::getClass()->getProductCardOrders();
    }

    /**
     * 删除预约产品
     *
     * @support  int $id 预约产品信息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrderItem () {
        return self::getClass()->deleteOrderItem();
    }

    /**
     * 发送邮件
     *
     * @support  string $email 邮箱 
     * @support  string $templateName 模板名称 
     * @support  array $data 邮件内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendEmailTest () {
        return self::getClass()->sendEmailTest();
    }

    /**
     * reviewCallback
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewCallback () {
        return self::getClass()->reviewCallback();
    }

    /**
     * reviewOrder
     *
     * @param  array $res 订单信息 [ require true ]
     * @param  int $adminId 发起人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewOrder (array $res, int $adminId) {
        return self::getClass()->reviewOrder([
            "res" => $res,
            "adminId" => $adminId,
        ]);
    }

    /**
     * 获取门店
     * @deprecated
     *
     * @support  string $type 模块(不传则获取所有) 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoresByType () {
        return self::getClass()->getStoresByType();
    }

    /**
     * 获取价格区和对应门店
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPriceAreaStore () {
        return self::getClass()->getPriceAreaStore();
    }

    /**
     * 根据门店ids获取对应产品信息
     *
     * @support  string $storeIds 门店ids [ require true ]
     * @support  string $type 模块 
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableProducts () {
        return self::getClass()->getAvailableProducts();
    }

    /**
     * 提取券码
     *
     * @support  array $num 提取数量 [ require true ]
     * @support  int $order_id 团购订单id [ require true ]
     * @support  array $item_ids 订单item ids(下标与num同步) [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $code 短信验证码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function drawCode () {
        return self::getClass()->drawCode();
    }

    /**
     * 导出券码列表
     *
     * @support  int $order_id 团购订单id [ require true ]
     * @support  string $code 短信验证码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportProductCardCodes () {
        return self::getClass()->exportProductCardCodes();
    }

    /**
     * 获取店长手机号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhone () {
        return self::getClass()->getPhone();
    }

    /**
     * handleGroupOrder
     *
     * @param  int $id 团购订单id [ require true ]
     * @param  int $payId 支付id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleGroupOrder (int $payId, int $id) {
        return self::getClass()->handleGroupOrder([
            "payId" => $payId,
            "id" => $id,
        ]);
    }

    /**
     * 根据支付方式获取订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $paid_at_start 支付时间开始 
     * @support  string $paid_at_end 支付时间结束 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPay () {
        return self::getClass()->getListByPay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\GroupOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\GroupOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}