<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeProductByParams(array $params)
 * @method infoByParams(array $params)
 * @method batchDetailByParams(array $params)
 * @method storeProductDetailByParams(array $params)
 * @method getStoreDiscountByParams(array $params)
 * @method getProductClothByParams(array $params)
 * @method testClearCacheByParams(array $params)
 * @method christmasActivitySettingByParams(array $params)
 * @method unpackChristmasMixByParams(array $params)
 * @method getGonggeAliasByParams(array $params)
 */
class ProductStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店所有产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function storeProduct () {
        return self::getClass()->storeProduct();
    }

    /**
     * 获取产品详情
     *
     * @support  int $product_id 产品ID [ require true ]
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 批量获取多个产品详情
     *
     * @support  array $product_ids 产品ID [ require true ]
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  array
     */
    public static function batchDetail () {
        return self::getClass()->batchDetail();
    }

    /**
     * 获取产品/服务详情
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeProductDetail (int $product_id) {
        return self::getClass()->storeProductDetail([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @support  int $store_id 门店ID [Original type uint] 
     * @support  bool $add_hour 是否包含一个小时内将会开始的活动 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreDiscount () {
        return self::getClass()->getStoreDiscount();
    }

    /**
     * 获取门店产品可选衣服
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCloth (int $product_id) {
        return self::getClass()->getProductCloth([
            "product_id" => $product_id,
        ]);
    }

    /**
     * testclearcache
     *
     * @support  string $key key [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function testClearCache () {
        return self::getClass()->testClearCache();
    }

    /**
     * 2020圣诞照配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function christmasActivitySetting () {
        return self::getClass()->christmasActivitySetting();
    }

    /**
     * 圣诞照Mix产品拆分
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  array $detail 产品详情组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unpackChristmasMix (int $storeId, array $detail) {
        return self::getClass()->unpackChristmasMix([
            "storeId" => $storeId,
            "detail" => $detail,
        ]);
    }

    /**
     * 获取全产品宫格别名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGonggeAlias () {
        return self::getClass()->getGonggeAlias();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\ProductStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\ProductStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}