<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method verifyOrderByParams(array $params)
 * @method detailByNumByParams(array $params)
 * @method changeNoteByParams(array $params)
 * @method changeAddressByParams(array $params)
 * @method createByParams(array $params)
 * @method userReachedByParams(array $params)
 * @method modifyUserReachedByParams(array $params)
 * @method setUserReachedPaidByParams(array $params)
 * @method getUserReachedDetailByParams(array $params)
 * @method groupOrderCreateByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method updateUserByParams(array $params)
 * @method cancelByParams(array $params)
 * @method paidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method clearTimeRecordByOrderByParams(array $params)
 * @method finishByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method removeByParams(array $params)
 * @method getCanUseCouponListByParams(array $params)
 * @method getCanUseProductCardListByParams(array $params)
 * @method jxjyCouponByParams(array $params)
 * @method getCouponInfoByParams(array $params)
 * @method getProductCardInfoByParams(array $params)
 * @method calCouponDeductionInfoByParams(array $params)
 * @method calProductDeductionInfoByParams(array $params)
 * @method calInteriorCouponDeductionInfoByParams(array $params)
 * @method workloadsByParams(array $params)
 * @method checkUserSubscribeByParams(array $params)
 * @method getEncryptOrderNumByParams(array $params)
 * @method getShortUrlByParams(array $params)
 * @method sendPayLinkByParams(array $params)
 * @method resetByParams(array $params)
 * @method workloadDetailByParams(array $params)
 * @method reserveProductCountByParams(array $params)
 * @method getProductDiscountByIdsByParams(array $params)
 * @method operateLogByParams(array $params)
 * @method createPayMaxPaymentByParams(array $params)
 * @method payMaxCallbackByParams(array $params)
 * @method getOrderClothByParams(array $params)
 * @method updateOrderClothByParams(array $params)
 * @method itemsCheckByParams(array $params)
 * @method cronCallByParams(array $params)
 * @method checkCallStatusByParams(array $params)
 * @method cronRedialByParams(array $params)
 * @method hookNotifyCallByParams(array $params)
 * @method callOrderUserByParams(array $params)
 * @method clearAutoFinishPhotoByParams(array $params)
 * @method cancelCallOrderByParams(array $params)
 * @method prepareByParams(array $params)
 * @method createPaymentByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 * @method cancelLookPhotoReserveTimeByParams(array $params)
 * @method batchLookingPhotoNumbersAndTimesByParams(array $params)
 * @method getLookingPhotoExtendInfoByParams(array $params)
 * @method getLookingPhotoNumbersByParams(array $params)
 * @method bigOrderByParams(array $params)
 * @method productDingByParams(array $params)
 * @method useGiftCardMoneyByParams(array $params)
 * @method useMarketCardMoneyByParams(array $params)
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method listByPayByParams(array $params)
 * @method getWxQrCodeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表查询
     *
     * @support  string $orderNo 订单号 
     * @support  string $reserveTimeStart 预约开始时间 
     * @support  string $reserveTimeEnd 预约结束时间 
     * @support  string $createTimeStart 查询开始时间 
     * @support  string $createTimeEnd 查询结束时间 
     * @support  string $status 订单状态 
     * @support  string $statusList 订单状态 
     * @support  string $module 模块 
     * @support  string $userName 下单用户 
     * @support  string $userPhone 手机号 
     * @support  int $userId 用户id 
     * @support  bool $allStore 是否查询所有门店 
     * @support  bool $isHangUp 是否查询挂起订单 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $sortField 排序字段 
     * @support  bool $sortDesc 是否倒序 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $orderNo 订单号 [ require true ]
     * @support  bool $withDelete 是否包含删除 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 核销订单
     *
     * @support  int $order_id 订单号 [Original type uint] [ require true ]
     * @support  string $activity_type 核销活动类型 
     * @support  string $type 核销产品类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function verifyOrder () {
        return self::getClass()->verifyOrder();
    }

    /**
     * 通过订单号获取订单详情
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  bool $with_del 是否包含删除 
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNum () {
        return self::getClass()->detailByNum();
    }

    /**
     * 修改订单备注
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeNote () {
        return self::getClass()->changeNote();
    }

    /**
     * 修改外拍订单地址
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $outsideCity 拍摄城市 [ require true ]
     * @support  string $outsideAddress 拍摄地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeAddress () {
        return self::getClass()->changeAddress();
    }

    /**
     * 创建订单
     *
     * @support  int $userId 用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实际金额(做校验用) [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  int $reachedPeopleNum 实际到店人数 [ require true ]
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  array $groupOrderItemIds 团购产品 
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 
     * @support  string $module 模块 
     * @support  string $outsideCity 外拍订单城市 
     * @support  string $outsideAddress 外拍地址 
     * @support  string $packageDiscountIds 套餐优惠信息 
     * @support  float $packageDiscountMoney 套餐优惠金额 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 设置拍摄订单签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $reachedPeopleNum 签到人数 [Original type uint] [ require true ]
     * @support  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @support  float $money 签到补收金额（如果不需要补收，可以为空） [Original type double] 
     * @throws  \Exception
     * @return  array
     */
    public static function userReached () {
        return self::getClass()->userReached();
    }

    /**
     * 修改拍摄订单签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $reachedPeopleNum 签到人数 [Original type uint] [ require true ]
     * @support  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @support  float $money 签到补收金额（如果不需要补收，可以为空） [Original type double] 
     * @throws  \Exception
     * @return  array
     */
    public static function modifyUserReached () {
        return self::getClass()->modifyUserReached();
    }

    /**
     * 设置签到完成支付
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  string $paymentNo 支付流水号 
     * @support  int $operateId 录单人 
     * @support  bool $fromPaymentGateway 来自支付网关 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserReachedPaid () {
        return self::getClass()->setUserReachedPaid();
    }

    /**
     * 如果没有数据，说明没有支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserReachedDetail (int $orderId) {
        return self::getClass()->getUserReachedDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 团购优惠订单创建
     *
     * @support  int $user_id 用户ID 
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_birthday 用户生日 
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  array $detail 订单详情（商品&amp;服务详情） [ require true ]
     * @support  array $group_order_item_ids 团购订单产品ids [ require true ]
     * @support  string $note 订单备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupOrderCreate () {
        return self::getClass()->groupOrderCreate();
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $user_id) {
        return self::getClass()->bindUser([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 取消绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 修改订单所属用户
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  string $phone 新绑定用户的手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUser () {
        return self::getClass()->updateUser();
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId orderDiffId [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号【管理端非必填】 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paid (int $id, int $orderDiffId, string $payType, string $paymentNo = '') {
        return self::getClass()->paid([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * clearTimeRecordByOrder
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearTimeRecordByOrder (int $order_id, int $store_id) {
        return self::getClass()->clearTimeRecordByOrder([
            "order_id" => $order_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 完成订单（拍摄完成）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function finish (int $id, array $workloads) {
        return self::getClass()->finish([
            "id" => $id,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 拍摄完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverFinishedToWaitShooting (int $id) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_sex 用户姓名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 删除订单
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 用户可用优惠券列表
     *
     * @support  array $product_group_ids 产品组ids 
     * @support  array $product_ids 产品ids [ require true ]
     * @support  array $service_product_ids 服务ids 
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $apply_in 应用于 
     * @support  int $order_id 订单id(用于查找当前订单已用券) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanUseCouponList () {
        return self::getClass()->getCanUseCouponList();
    }

    /**
     * 用户可用产品卡列表
     *
     * @support  array $product_group_ids 产品组ids 
     * @support  array $product_ids 产品ids [ require true ]
     * @support  array $service_product_ids 服务ids 
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $apply_in 应用于 
     * @support  int $order_id 订单id(用于查找当前订单已用券) 
     * @throws  \Exception
     * @return  array
     */
    public static function getCanUseProductCardList () {
        return self::getClass()->getCanUseProductCardList();
    }

    /**
     * 获取用户加修加印券
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @support  array $product_group_ids 产品组ids 
     * @param  array $product_ids 产品ids [ require true ]
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  mixed
     */
    public static function jxjyCoupon (int $user_id, array $product_ids) {
        return self::getClass()->jxjyCoupon([
            "user_id" => $user_id,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 获取优惠券详情
     *
     * @param  int $id 优惠券id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponInfo (int $id) {
        return self::getClass()->getCouponInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品券详情
     *
     * @param  int $id 产品券id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCardInfo (int $id) {
        return self::getClass()->getProductCardInfo([
            "id" => $id,
        ]);
    }

    /**
     * 计算优惠券可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $coupon_id 优惠券ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function calCouponDeductionInfo () {
        return self::getClass()->calCouponDeductionInfo();
    }

    /**
     * 计算产品卡可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $product_card_id 产品卡ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function calProductDeductionInfo () {
        return self::getClass()->calProductDeductionInfo();
    }

    /**
     * 订单开单折扣码抵扣
     *
     * @support  string $interior_coupon_code 开单折扣码 [ require true ]
     * @support  bool $verify_usability 验证可用性 
     * @throws  \Exception
     * @return  mixed
     */
    public static function calInteriorCouponDeductionInfo () {
        return self::getClass()->calInteriorCouponDeductionInfo();
    }

    /**
     * 录入工作量
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $workloads 工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workloads () {
        return self::getClass()->workloads();
    }

    /**
     * 检查订单用户是否关注公众号
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserSubscribe (int $user_id) {
        return self::getClass()->checkUserSubscribe([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取加密订单号
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getEncryptOrderNum (string $order_num) {
        return self::getClass()->getEncryptOrderNum([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 获取短链接
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $url 付款链接前缀 [ require true ]
     * @param  string $pay_type 类型(首款或者尾款) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShortUrl (string $order_num, string $url, string $pay_type = '') {
        return self::getClass()->getShortUrl([
            "order_num" => $order_num,
            "url" => $url,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 发送付款链接
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $url 付款链接 [ require true ]
     * @param  string $phone 电话号码 [ require true ]
     * @param  string $orderType 订单类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPayLink (int $orderId, string $url, string $orderType, string $phone) {
        return self::getClass()->sendPayLink([
            "orderId" => $orderId,
            "url" => $url,
            "orderType" => $orderType,
            "phone" => $phone,
        ]);
    }

    /**
     * 重置工作量
     *
     * @support  int $order_id 订单ID [ require true ]
     * @support  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reset () {
        return self::getClass()->reset();
    }

    /**
     * 工作量查询
     *
     * @support  string $order_num 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workloadDetail () {
        return self::getClass()->workloadDetail();
    }

    /**
     * 获取当日售卖产品总数
     *
     * @support  string $reserveTimeStart 起始时间 
     * @support  string $reserveTimeEnd 结束时间 
     * @support  string $module 模块 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function reserveProductCount () {
        return self::getClass()->reserveProductCount();
    }

    /**
     * 折扣列表
     *
     * @support  string $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountByIds () {
        return self::getClass()->getProductDiscountByIds();
    }

    /**
     * 管理端查询订单操作记录
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operateLog (int $order_id) {
        return self::getClass()->operateLog([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 创建拉卡拉线下支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展字段 
     * @throws  \Exception
     * @return  array
     */
    public static function createPayMaxPayment () {
        return self::getClass()->createPayMaxPayment();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payMaxCallback () {
        return self::getClass()->payMaxCallback();
    }

    /**
     * 获取订单选衣信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderCloth (int $order_id) {
        return self::getClass()->getOrderCloth([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 签到更新性别和到店人数
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $items 各产品 [ require true ]
     * @param  int $reached_people_num 到店人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateOrderCloth (int $order_id, array $items, int $reached_people_num = 0) {
        return self::getClass()->updateOrderCloth([
            "order_id" => $order_id,
            "items" => $items,
            "reached_people_num" => $reached_people_num,
        ]);
    }

    /**
     * 门店新增子订单处理选衣
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  array $item_ids 子订单itemids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemsCheck (int $order_id, array $item_ids) {
        return self::getClass()->itemsCheck([
            "order_id" => $order_id,
            "item_ids" => $item_ids,
        ]);
    }

    /**
     * 定时通知距离预约时间只有一小时的顾客
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCall () {
        return self::getClass()->cronCall();
    }

    /**
     * 定时检查通话回执
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkCallStatus () {
        return self::getClass()->checkCallStatus();
    }

    /**
     * 定时检查是否需要重拨
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronRedial () {
        return self::getClass()->cronRedial();
    }

    /**
     * hookNotifyCall
     *
     * @param  string $call_id callId [ require true ]
     * @param  int $duration 时长 [ require true ]
     * @param  string $status_code 通话状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookNotifyCall (string $call_id, int $duration, string $status_code) {
        return self::getClass()->hookNotifyCall([
            "call_id" => $call_id,
            "duration" => $duration,
            "status_code" => $status_code,
        ]);
    }

    /**
     * callOrderUser
     *
     * @param  array $order 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callOrderUser (array $order) {
        return self::getClass()->callOrderUser([
            "order" => $order,
        ]);
    }

    /**
     * 清除自动看片完成订单的顾客满意片
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearAutoFinishPhoto (int $order_id) {
        return self::getClass()->clearAutoFinishPhoto([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 不再呼叫
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelCallOrder (int $order_id) {
        return self::getClass()->cancelCallOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 校验美团大众券信息
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function prepare (string $receipt_code, int $store_id) {
        return self::getClass()->prepare([
            "receipt_code" => $receipt_code,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 创建美团大众点评支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $group_id 团购ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createPayment () {
        return self::getClass()->createPayment();
    }

    /**
     * 修改看片预约时间
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $look_photo_reserve_time 看片预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeLookPhotoReserveTime (int $order_id, string $look_photo_reserve_time) {
        return self::getClass()->changeLookPhotoReserveTime([
            "order_id" => $order_id,
            "look_photo_reserve_time" => $look_photo_reserve_time,
        ]);
    }

    /**
     * 取消看片预约
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelLookPhotoReserveTime (int $order_id) {
        return self::getClass()->cancelLookPhotoReserveTime([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 批量获取看片照片数量和时长
     *
     * @param  array $order_ids 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchLookingPhotoNumbersAndTimes (array $order_ids) {
        return self::getClass()->batchLookingPhotoNumbersAndTimes([
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * 获取看片照片数量,时长,看片通知时间 - bms
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLookingPhotoExtendInfo (int $order_id) {
        return self::getClass()->getLookingPhotoExtendInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取看片照片数量
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLookingPhotoNumbers (int $order_id) {
        return self::getClass()->getLookingPhotoNumbers([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 是否是大订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bigOrder (int $order_id) {
        return self::getClass()->bigOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 特殊产品ding门店伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDing () {
        return self::getClass()->productDing();
    }

    /**
     * 修改使用礼品卡金额
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $giftCardPayMoney 礼品卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useGiftCardMoney () {
        return self::getClass()->useGiftCardMoney();
    }

    /**
     * 修改使用商场卡金额
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $marketCardMoney 商场卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useMarketCardMoney () {
        return self::getClass()->useMarketCardMoney();
    }

    /**
     * 使用礼品卡支付确认的推送
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardMoney 礼品卡支付金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return self::getClass()->sendGiftCardPayDsConfirmPush([
            "id" => $id,
            "giftCardMoney" => $giftCardMoney,
        ]);
    }

    /**
     * 查账助手-根据订单类型获取
     *
     * @support  string $orderType 订单类型 
     * @support  string $type 子订单类型：order,ds 
     * @support  string $status 状态 
     * @support  string $statusList 状态列表 
     * @support  string $payType 支付类型，同子订单支付类型 
     * @support  string $paidAtStart 支付时间起始 [ require true ]
     * @support  string $paidAtEnd 支付时间结束 [ require true ]
     * @support  string $pageSize  
     * @support  string $page  
     * @throws  \Exception
     * @return  mixed
     */
    public static function listByPay () {
        return self::getClass()->listByPay();
    }

    /**
     * 获取临时二维码
     *
     * @support  string $key 二维码key值 [ require true ]
     * @support  string $expireSeconds 过期时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWxQrCode () {
        return self::getClass()->getWxQrCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}