<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryWaitReviewListByParams(array $params)
 * @method queryWaitFinishListByParams(array $params)
 * @method getWaitRetouchNumByParams(array $params)
 * @method changeSecondRetouchStoreByParams(array $params)
 * @method cancelChangeSecondRetouchStoreByParams(array $params)
 * @method getSecondRetouchChangeStoreOrderListByParams(array $params)
 * @method assignSecondRetouchByParams(array $params)
 * @method bindCheckerByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method reviewByParams(array $params)
 * @method getCheckerUnReadStreamCountByParams(array $params)
 * @method readCountByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method autoWatchPhotoNotifyByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method cronCheckAndRemoveUnReviewOrderByParams(array $params)
 * @method cronCheckAndRemoveUnReviewOrderTestByParams(array $params)
 * @method getRemoveOrderTestByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method cleanNotifyByParams(array $params)
 * @method getPictureOnlineRetoucherByParams(array $params)
 * @method readyWorkByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method autoSetFinishedPhotoByParams(array $params)
 * @method reworkStreamByParams(array $params)
 * @method kpsOrderAgainByParams(array $params)
 * @method hookCloudFinishStreamByParams(array $params)
 * @method hookCloudDeleteStreamByParams(array $params)
 * @method hookPictureOnlineTakeOrderByParams(array $params)
 * @method hookPictureOnlineCompleteOrderByParams(array $params)
 * @method hookHimoSetWorkloadsByParams(array $params)
 * @method hookTestByParams(array $params)
 * @method clearReviewByParams(array $params)
 * @method changeStageTestByParams(array $params)
 * @method cloudStreamTestByParams(array $params)
 * @method getStreamStatusByParams(array $params)
 * @method getTemplatesByProductIdsByParams(array $params)
 * @method getPhotoCompleteItemIdsByOrderIdByParams(array $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method cancelAuthByParams(array $params)
 * @method hookPictureOrderChangeToStoreByParams(array $params)
 * @method hookPictureOrderTagDissatisfiedByParams(array $params)
 * @method testSyncNewPictureOnlineByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $order_num 订单号 
     * @support  string $user_name 姓名 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitReviewList () {
        return self::getClass()->queryWaitReviewList();
    }

    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     *
     * @support  string $order_num 订单号 
     * @support  string $user_name 姓名 
     * @support  string $user_phone 手机号 
     * @support  string $brand 品牌 
     * @support  string $whole_order_num 全国范围订单号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitFinishList () {
        return self::getClass()->queryWaitFinishList();
    }

    /**
     * 获取门店待审核数【本门店＋转门店】
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitRetouchNum () {
        return self::getClass()->getWaitRetouchNum();
    }

    /**
     * 转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSecondRetouchStore (string $orderNum) {
        return self::getClass()->changeSecondRetouchStore([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 取消转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelChangeSecondRetouchStore (string $orderNum) {
        return self::getClass()->cancelChangeSecondRetouchStore([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取转门店订单列表
     *
     * @support  string $order_num 订单号 
     * @support  string $user_name 姓名 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getSecondRetouchChangeStoreOrderList () {
        return self::getClass()->getSecondRetouchChangeStoreOrderList();
    }

    /**
     * 看片指派【看片】
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  int $staff_id 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignSecondRetouch (string $order_num, int $staff_id) {
        return self::getClass()->assignSecondRetouch([
            "order_num" => $order_num,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 绑定审核人id
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 订单详情
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * 提交审核
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  string $evaluate 评价 
     * @support  array $photo 照片 
     * @support  string $note 评语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function review () {
        return self::getClass()->review();
    }

    /**
     * 获取未读流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckerUnReadStreamCount () {
        return self::getClass()->getCheckerUnReadStreamCount();
    }

    /**
     * 已读流水接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function readCount () {
        return self::getClass()->readCount();
    }

    /**
     * 发送看片通知
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 看片通知(bms调用,用于自动看片推送)
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoWatchPhotoNotify (int $order_id) {
        return self::getClass()->autoWatchPhotoNotify([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 看片审核历史列表
     *
     * @support  string $order_num 订单号 
     * @support  string $user_phone 手机号 
     * @support  string $user_name 姓名 
     * @support  string $brand 品牌 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  bool $search_without_staff 不根据伙伴查询 
     * @support  bool $changed_store 是否为转门店数据 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory();
    }

    /**
     * (定时任务:)修改未审核完成的流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCheckAndRemoveUnReviewOrder () {
        return self::getClass()->cronCheckAndRemoveUnReviewOrder();
    }

    /**
     * (定时任务:)修改未审核完成的流水test定时任务
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCheckAndRemoveUnReviewOrderTest () {
        return self::getClass()->cronCheckAndRemoveUnReviewOrderTest();
    }

    /**
     * (首次登录:)提示用户有未完成的订单审核
     *
     * @param  int $staff_id staff_id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRemoveOrderTest (int $staff_id) {
        return self::getClass()->getRemoveOrderTest([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 清除未完成的订单列表提示
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanNotify () {
        return self::getClass()->cleanNotify();
    }

    /**
     * 获取在线看片师信息
     *
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPictureOnlineRetoucher (int $staff_id) {
        return self::getClass()->getPictureOnlineRetoucher([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 看片师准备
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function readyWork () {
        return self::getClass()->readyWork();
    }

    /**
     * 看片师已接订单[取多单]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnline () {
        return self::getClass()->getOrderOnline();
    }

    /**
     * 获取看片师订单详情
     * @deprecated
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (int $order_id) {
        return self::getClass()->getOrderInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取看片师订单历史上传记录详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryInfo (int $order_id) {
        return self::getClass()->getHistoryInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  string $order_num 订单号 
     * @support  string $user_name 顾客姓名 
     * @support  string $user_phone 顾客手机号 
     * @support  bool $search_without_staff 不根据伙伴查询 
     * @support  bool $changed_store 是否为转门店数据 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 提交最终成片
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  array $photo_data 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitFinalPhoto (string $stream_num, array $photo_data) {
        return self::getClass()->submitFinalPhoto([
            "stream_num" => $stream_num,
            "photo_data" => $photo_data,
        ]);
    }

    /**
     * 系统自动看片设置成片(RPC调用)
     *
     * @param  int $order_id order_id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSetFinishedPhoto (int $order_id) {
        return self::getClass()->autoSetFinishedPhoto([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 看片退单
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  array $photo_data 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reworkStream (string $stream_num, array $photo_data) {
        return self::getClass()->reworkStream([
            "stream_num" => $stream_num,
            "photo_data" => $photo_data,
        ]);
    }

    /**
     * 看片师再来一单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function kpsOrderAgain () {
        return self::getClass()->kpsOrderAgain();
    }

    /**
     * 接收云端流水完成事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudFinishStream (string $stream_num) {
        return self::getClass()->hookCloudFinishStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 接收云端流水删除事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudDeleteStream (string $stream_num) {
        return self::getClass()->hookCloudDeleteStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 接收在线看片接单事件
     *
     * @param  string $outsideNo 订单号 [ require true ]
     * @param  int $watcherId 看片师工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOnlineTakeOrder (string $outsideNo, int $watcherId) {
        return self::getClass()->hookPictureOnlineTakeOrder([
            "outsideNo" => $outsideNo,
            "watcherId" => $watcherId,
        ]);
    }

    /**
     * 接收在线看片完成事件
     *
     * @param  string $outsideNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOnlineCompleteOrder (string $outsideNo) {
        return self::getClass()->hookPictureOnlineCompleteOrder([
            "outsideNo" => $outsideNo,
        ]);
    }

    /**
     * 接收录工作量事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  array $workloads 工作量数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookHimoSetWorkloads (int $orderId, array $workloads) {
        return self::getClass()->hookHimoSetWorkloads([
            "orderId" => $orderId,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 接收云端流水完成事件(api test)
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookTest (string $stream_num) {
        return self::getClass()->hookTest([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 清除审核人
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearReview (int $order_id) {
        return self::getClass()->clearReview([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 调整无纸化状态
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $pending_status 无纸化状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStageTest (int $order_id, string $pending_status) {
        return self::getClass()->changeStageTest([
            "order_id" => $order_id,
            "pending_status" => $pending_status,
        ]);
    }

    /**
     * 调整流水
     *
     * @param  int $stream_id stream_id [ require true ]
     * @param  array $raw 需要修改的数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cloudStreamTest (int $stream_id, array $raw) {
        return self::getClass()->cloudStreamTest([
            "stream_id" => $stream_id,
            "raw" => $raw,
        ]);
    }

    /**
     * 获取流水状态
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamStatus () {
        return self::getClass()->getStreamStatus();
    }

    /**
     * 获取产品贴图模板
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplatesByProductIds (array $productIds) {
        return self::getClass()->getTemplatesByProductIds([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取流水状态
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoCompleteItemIdsByOrderId (int $orderId) {
        return self::getClass()->getPhotoCompleteItemIdsByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取流水状态
     *
     * @param  string $orderNum 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo (string $orderNum) {
        return self::getClass()->getCloudStreamInfo([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice();
    }

    /**
     * 取消授权
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAuth () {
        return self::getClass()->cancelAuth();
    }

    /**
     * hookPictureOrderChangeToStore
     *
     * @support  int $retoucher_no 修片师 [Original type uint] [ require true ]
     * @support  string $customer_name 顾客名 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOrderChangeToStore () {
        return self::getClass()->hookPictureOrderChangeToStore();
    }

    /**
     * hookPictureOrderTagDissatisfied
     *
     * @support  int $retoucher_no 修片师 [Original type uint] [ require true ]
     * @support  string $customer_name 顾客名 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOrderTagDissatisfied () {
        return self::getClass()->hookPictureOrderTagDissatisfied();
    }

    /**
     * 测试迁移
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function testSyncNewPictureOnline (string $orderNum) {
        return self::getClass()->testSyncNewPictureOnline([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}