<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPassProductIdsByParams(array $params)
 * @method getOrdersCallRecordByParams(array $params)
 */
class Paperless {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴已通关产品id列表
     *
     * @support  array $staffIds 伙伴id列表 
     * @throws  \Exception
     * @return  array
     */
    public static function getPassProductIds () {
        return self::getClass()->getPassProductIds();
    }

    /**
     * 获取订单的致电记录
     *
     * @support  array $orderIds 订单id列表 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrdersCallRecord () {
        return self::getClass()->getOrdersCallRecord();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\Paperless');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\Paperless');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}