<?php
namespace Mainto\Bridge\Invokes\HimoProductStore;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderAllPendingStatusByParams(array $params)
 * @method addReceptionistRecordByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method giveOrderToStaffInManageByParams(array $params)
 * @method getStaffWorkStatesByParams(array $params)
 * @method removeStaffHangStateByParams(array $params)
 * @method getProcessStaffByParams(array $params)
 * @method getDresserRemarkByParams(array $params)
 * @method changeStateByCloudByParams(array $params)
 * @method removeHangOrderByParams(array $params)
 * @method hangOrderByParams(array $params)
 * @method adjustQueueSortByParams(array $params)
 * @method assignStaffByParams(array $params)
 * @method removeAssignStaffByParams(array $params)
 * @method queryStoresByParams(array $params)
 * @method getCurrentProcessingStaffByParams(array $params)
 * @method returnToWaitByParams(array $params)
 * @method getCanTakeOrderStaffsByParams(array $params)
 * @method orderHasHiddenProductsByParams(array $params)
 * @method orderAvailableTakersByParams(array $params)
 * @method qtAvailableTakersByParams(array $params)
 * @method cronChangeToWaitingByParams(array $params)
 * @method changePhotoToProcessingByParams(array $params)
 * @method getPhotographyMakeUpTimeByParams(array $params)
 * @method clearUnfinishedOrderNoPaperInfoByParams(array $params)
 * @method trafficStatisticsByParams(array $params)
 * @method getCurrentHangStaffsByParams(array $params)
 * @method getHangActionTimeoutStaffsByParams(array $params)
 * @method dingUsersWhenOrderHangingTimeOutByParams(array $params)
 * @method getProductClothByParams(array $params)
 * @method updateOrderClothByParams(array $params)
 * @method getOrderGuestsNumByParams(array $params)
 * @method duringWorkByParams(array $params)
 * @method getWorkDetailByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method readyWorkByParams(array $params)
 * @method lookPhotoWarnBroadcastTestByParams(array $params)
 * @method noPaperStatusCheckByParams(array $params)
 * @method getDingDingHeadByParams(array $params)
 * @method cronCleanStaffStateByParams(array $params)
 * @method cronCleanOrderProductOnlinesByParams(array $params)
 * @method delWorkTimeByParams(array $params)
 * @method refundNoticeByParams(array $params)
 * @method refundThenTakeOrderByParams(array $params)
 * @method refundThenNoticeAssistanceByParams(array $params)
 * @method afterChangeAssistanceByParams(array $params)
 * @method getSortedStaffByParams(array $params)
 * @method getTeamByParams(array $params)
 * @method fixDataByParams(array $params)
 * @method fixDeleteDataByParams(array $params)
 * @method fixAddDataByParams(array $params)
 * @method fixClearCacheByParams(array $params)
 * @method makeUpRemarkByParams(array $params)
 * @method fixRedisByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前门店下所有订单的状态[done]
     *
     * @support  int $store_id 店铺id 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllPendingStatus () {
        return self::getClass()->getOrderAllPendingStatus();
    }

    /**
     * 前台签到排队 done
     *
     * @support  int $staff_id 员工id 
     * @support  int $order_id 订单id [ require true ]
     * @support  int $dresser_id 指定的化妆师id 
     * @support  int $cameraman_id 指定的摄影师id 
     * @support  int $second_retoucher_id 指定的看片师id 
     * @support  bool $skip_make_up 是否跳过化妆 
     * @support  string $group_name 团队名 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceptionistRecord () {
        return self::getClass()->addReceptionistRecord();
    }

    /**
     * 获取门店在当前等待队列队尾序号[done]
     *
     * @support  int $store_id 门店id 
     * @support  string $pending_status 类型 
     * @throws  \Exception
     * @return  int
     */
    public static function getLastQueueSort () {
        return self::getClass()->getLastQueueSort();
    }

    /**
     * 管理端分配订单给某人
     *
     * @support  string $staff_type 用户类型 [ require true ]
     * @support  int $to_staff_id 分配给某人 [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function giveOrderToStaffInManage () {
        return self::getClass()->giveOrderToStaffInManage();
    }

    /**
     * 获取伙伴当前工作状态[done]
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffWorkStates () {
        return self::getClass()->getStaffWorkStates();
    }

    /**
     * 解除挂起
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $staff_id staff id [ require true ]
     * @support  string $staff_type 伙伴类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHangState () {
        return self::getClass()->removeStaffHangState();
    }

    /**
     * 获取订单无纸化流程伙伴信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff (int $order_id) {
        return self::getClass()->getProcessStaff([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取化妆备注
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getDresserRemark () {
        return self::getClass()->getDresserRemark();
    }

    /**
     * 云图端结束摄影中状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStateByCloud (string $orderNum, string $remark = '') {
        return self::getClass()->changeStateByCloud([
            "orderNum" => $orderNum,
            "remark" => $remark,
        ]);
    }

    /**
     * 解除挂起的订单
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeHangOrder () {
        return self::getClass()->removeHangOrder();
    }

    /**
     * 挂起订单
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangOrder () {
        return self::getClass()->hangOrder();
    }

    /**
     * 调整订单排序
     *
     * @support  int $order_id order id [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustQueueSort () {
        return self::getClass()->adjustQueueSort();
    }

    /**
     * 指定化妆师或者摄影师
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $dresser_id 化妆师id 
     * @support  int $cameraman_id 摄影师id 
     * @support  int $second_retoucher_id 摄影师id 
     * @throws  \Exception
     * @return  array
     */
    public static function assignStaff () {
        return self::getClass()->assignStaff();
    }

    /**
     * 清除指派的化妆师或者摄影师
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $staff_type 伙伴类型 
     * @throws  \Exception
     * @return  array
     */
    public static function removeAssignStaff () {
        return self::getClass()->removeAssignStaff();
    }

    /**
     * [管]门店列表
     *
     * @param  string $classification_nums 区域id;用,隔开 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStores (string $classification_nums = '') {
        return self::getClass()->queryStores([
            "classification_nums" => $classification_nums,
        ]);
    }

    /**
     * 获取当前处理订单的伙伴
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentProcessingStaff () {
        return self::getClass()->getCurrentProcessingStaff();
    }

    /**
     * 退回等待状态
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToWait () {
        return self::getClass()->returnToWait();
    }

    /**
     * 获取可接单伙伴的信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanTakeOrderStaffs () {
        return self::getClass()->getCanTakeOrderStaffs();
    }

    /**
     * 订单是否存在下架产品
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderHasHiddenProducts () {
        return self::getClass()->orderHasHiddenProducts();
    }

    /**
     * 获取可接单的伙伴id
     *
     * @support  array $staff_ids 伙伴ids [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderAvailableTakers () {
        return self::getClass()->orderAvailableTakers();
    }

    /**
     * 获取门市客服服务通关的伙伴id
     *
     * @param  array $staff_ids 伙伴ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function qtAvailableTakers (array $staff_ids) {
        return self::getClass()->qtAvailableTakers([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronChangeToWaiting () {
        return self::getClass()->cronChangeToWaiting();
    }

    /**
     * 摄影等待状态至进行中
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePhotoToProcessing (int $storeId, int $orderId, int $productId, int $staffId) {
        return self::getClass()->changePhotoToProcessing([
            "storeId" => $storeId,
            "orderId" => $orderId,
            "productId" => $productId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取等待中订单的信息和时间
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographyMakeUpTime () {
        return self::getClass()->getPhotographyMakeUpTime();
    }

    /**
     * clearUnfinishedOrderNoPaperInfo
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearUnfinishedOrderNoPaperInfo () {
        return self::getClass()->clearUnfinishedOrderNoPaperInfo();
    }

    /**
     * 流量看板
     *
     * @support  array $store_ids 门店组 [ require true ]
     * @support  string $date 时间 
     * @throws  \Exception
     * @return  array
     */
    public static function trafficStatistics () {
        return self::getClass()->trafficStatistics();
    }

    /**
     * 获取当前挂起的用户
     *
     * @support  int $store_id 门店 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentHangStaffs () {
        return self::getClass()->getCurrentHangStaffs();
    }

    /**
     * 获取当前挂起的用户
     *
     * @support  int $store_id 门店 [ require true ]
     * @support  int $minutes 分钟数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHangActionTimeoutStaffs () {
        return self::getClass()->getHangActionTimeoutStaffs();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingUsersWhenOrderHangingTimeOut () {
        return self::getClass()->dingUsersWhenOrderHangingTimeOut();
    }

    /**
     * 获取门店产品可选衣服
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCloth (int $store_id, int $product_id) {
        return self::getClass()->getProductCloth([
            "store_id" => $store_id,
            "product_id" => $product_id,
        ]);
    }

    /**
     * 更新订单服装
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $items 各产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateOrderCloth (int $order_id, array $items) {
        return self::getClass()->updateOrderCloth([
            "order_id" => $order_id,
            "items" => $items,
        ]);
    }

    /**
     * 获取产品人数
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $item_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderGuestsNum () {
        return self::getClass()->getOrderGuestsNum();
    }

    /**
     * 获取用时明细
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function duringWork () {
        return self::getClass()->duringWork();
    }

    /**
     * 获取当日工作明细
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWorkDetail (int $store_id, int $staff_id) {
        return self::getClass()->getWorkDetail([
            "store_id" => $store_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 记录备注
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $product_id 产品id [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveNote (int $order_id, int $product_id, int $staff_id, string $note = '') {
        return self::getClass()->saveNote([
            "order_id" => $order_id,
            "product_id" => $product_id,
            "staff_id" => $staff_id,
            "note" => $note,
        ]);
    }

    /**
     * ws准备
     *
     * @support  string $ws_staff_type 连接ws伙伴类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function readyWork () {
        return self::getClass()->readyWork();
    }

    /**
     * ws广播测试
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function lookPhotoWarnBroadcastTest (int $order_id) {
        return self::getClass()->lookPhotoWarnBroadcastTest([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 每30分钟执行一次 将无纸化的数据设置成热点数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function noPaperStatusCheck () {
        return self::getClass()->noPaperStatusCheck();
    }

    /**
     * 获取钉钉头像
     *
     * @param  int $staff_id 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDingDingHead (int $staff_id) {
        return self::getClass()->getDingDingHead([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 每天0点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCleanStaffState () {
        return self::getClass()->cronCleanStaffState();
    }

    /**
     * 每天0点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCleanOrderProductOnlines () {
        return self::getClass()->cronCleanOrderProductOnlines();
    }

    /**
     * 清除时间记录
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delWorkTime (array $productIds, int $orderId) {
        return self::getClass()->delWorkTime([
            "productIds" => $productIds,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 退款通知事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundNotice (int $storeId, int $orderId) {
        return self::getClass()->refundNotice([
            "storeId" => $storeId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 退款自动接单事件
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $staffType 员工类型 [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundThenTakeOrder (int $storeId, string $staffType, int $staffId) {
        return self::getClass()->refundThenTakeOrder([
            "storeId" => $storeId,
            "staffType" => $staffType,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 退款接产品通知事件
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  string $staffType 员工类型 [ require true ]
     * @param  string $notifyType 通知类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundThenNoticeAssistance (int $storeId, int $staffId, int $orderId, string $staffType, string $notifyType = 'order_refund_receive_order') {
        return self::getClass()->refundThenNoticeAssistance([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "orderId" => $orderId,
            "staffType" => $staffType,
            "notifyType" => $notifyType,
        ]);
    }

    /**
     * 换产品完成化妆事件
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $makeUpNum 化妆人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterChangeAssistance (int $storeId, int $staffId, int $orderId, int $makeUpNum) {
        return self::getClass()->afterChangeAssistance([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "orderId" => $orderId,
            "makeUpNum" => $makeUpNum,
        ]);
    }

    /**
     * 新无纸化获取门店可接单员工
     *
     * @param  string $staffType 员工类型 [ require true ]
     * @param  string $groupName 团队名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSortedStaff (string $staffType, string $groupName) {
        return self::getClass()->getSortedStaff([
            "staffType" => $staffType,
            "groupName" => $groupName,
        ]);
    }

    /**
     * 新无纸化获取门店可接单员工
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTeam (int $storeId) {
        return self::getClass()->getTeam([
            "storeId" => $storeId,
        ]);
    }

    /**
     * fixData
     *
     * @param  string $token token [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @param  string $status 员工类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixData (int $orderId, int $productId, int $staffId, string $token, string $status) {
        return self::getClass()->fixData([
            "orderId" => $orderId,
            "productId" => $productId,
            "staffId" => $staffId,
            "token" => $token,
            "status" => $status,
        ]);
    }

    /**
     * fixDeleteData
     *
     * @param  string $token token [ require true ]
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixDeleteData (int $id, string $token) {
        return self::getClass()->fixDeleteData([
            "id" => $id,
            "token" => $token,
        ]);
    }

    /**
     * fixAddData
     *
     * @param  string $token token [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixAddData (int $orderId, int $productId, int $staffId, string $token, string $status) {
        return self::getClass()->fixAddData([
            "orderId" => $orderId,
            "productId" => $productId,
            "staffId" => $staffId,
            "token" => $token,
            "status" => $status,
        ]);
    }

    /**
     * fixClearCache
     *
     * @param  string $token token [ require true ]
     * @param  string $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixClearCache (string $storeId, string $token) {
        return self::getClass()->fixClearCache([
            "storeId" => $storeId,
            "token" => $token,
        ]);
    }

    /**
     * 修改化妆备注
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 伙伴工号 [ require true ]
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeUpRemark () {
        return self::getClass()->makeUpRemark();
    }

    /**
     * fixRedis
     *
     * @param  string $token token [ require true ]
     * @param  string $connection connection [ require true ]
     * @param  string $cmd cmd [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixRedis (string $token, string $connection, string $cmd) {
        return self::getClass()->fixRedis([
            "token" => $token,
            "connection" => $connection,
            "cmd" => $cmd,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}