<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkSignByParams(array $params)
 * @method getMaterialCategoriesByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method getMaterialManageListByParams(array $params)
 * @method getMaterialByParams(array $params)
 * @method getMaterialNamesByCodeByParams(array $params)
 * @method getMaterialsByNameByParams(array $params)
 * @method syncMaterialTypeByParams(array $params)
 * @method syncMaterialByParams(array $params)
 * @method syncMaterialSkuByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * checkSign
     *
     * @param  string $sign sign [ require true ]
     * @param  string $token token [ require true ]
     * @param  string $timestamp timestamp [ require true ]
     * @support  string $name name 
     * @throws  \Exception
     * @return  string
     */
    public static function checkSign (string $sign, string $token, string $timestamp) {
        return self::getClass()->checkSign([
            "sign" => $sign,
            "token" => $token,
            "timestamp" => $timestamp,
        ]);
    }

    /**
     * 获取物料分类
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialCategories () {
        return self::getClass()->getMaterialCategories();
    }

    /**
     * 获取物料列表(根据门店属性查询)
     *
     * @support  array $categoryIds 分类id数组 
     * @support  string $name 物料名称 
     * @support  string $storeType 门店类型 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料管理列表(BMS使用)
     *
     * @support  array $categoryIds 分类id数组 
     * @support  string $name 物料名称 
     * @support  string $storeType 门店类型 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialManageList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getMaterialManageList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getMaterial
     *
     * @param  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial (string $code) {
        return self::getClass()->getMaterial([
            "code" => $code,
        ]);
    }

    /**
     * getMaterialNamesByCode
     *
     * @support  array $code 物料编码 
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialNamesByCode () {
        return self::getClass()->getMaterialNamesByCode();
    }

    /**
     * getMaterialsByName
     *
     * @param  string $name 物料名称 [ require true ]
     * @support  int $isFixedAsset 是否固定资产,1是0否无全部 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialsByName (string $name) {
        return self::getClass()->getMaterialsByName([
            "name" => $name,
        ]);
    }

    /**
     * 同步物料分类
     *
     * @param  int $category_id 分类id [ require true ]
     * @param  int $parent_id 父级id [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @param  int $level 级别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterialType (int $category_id, int $parent_id, string $name, int $level) {
        return self::getClass()->syncMaterialType([
            "category_id" => $category_id,
            "parent_id" => $parent_id,
            "name" => $name,
            "level" => $level,
        ]);
    }

    /**
     * 同步物料主体信息
     *
     * @param  string $code 物料编码 [ require true ]
     * @support  string $name 物料名称 [ require true ]
     * @support  string $image_url 物料图片 
     * @support  int $category_id 分类id [ require true ]
     * @support  int $brand_id 品牌id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterial (string $code) {
        return self::getClass()->syncMaterial([
            "code" => $code,
        ]);
    }

    /**
     * 同步物料详情
     *
     * @param  string $code 物料编码 [ require true ]
     * @param  int $sku_id sku id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterialSku (int $sku_id, string $code) {
        return self::getClass()->syncMaterialSku([
            "sku_id" => $sku_id,
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}