<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method afterSaleByParams(array $params)
 * @method getAfterSaleOrderDetailByParams(array $params)
 * @method createByParams(array $params)
 * @method closeByParams(array $params)
 */
class AfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * TODO 权限
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterSale (int $orderId) {
        return self::getClass()->afterSale([
            "orderId" => $orderId,
        ]);
    }

    /**
     * TODO 权限
     *
     * @support  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAfterSaleOrderDetail () {
        return self::getClass()->getAfterSaleOrderDetail();
    }

    /**
     * 创建售后单
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $type 售后单类型 [ require true ]
     * @support  array $refundItemDetail 退款商品明细 
     * @support  string $reason 退款原因 [ require true ]
     * @support  string $note 退换货说明 
     * @support  bool $confirmReturnInvoice 确认须退发票 
     * @support  float $money 退款金额 [Original type double] 
     * @support  string $people 退款人 
     * @support  string $account 退款账户 
     * @support  int $isStaffPay 是否为伙伴垫付 
     * @support  array $staffPayCertificate 对公打款支付凭证图片地址 
     * @support  string $from 退款来源:user 用户端， manager 后台 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * TODO 权限
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Retail\AfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Retail\AfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}