<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductsByParams(array $params)
 * @method getProductByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method getProductBySkuCodeByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取商品s
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @support  string $name 名称 
     * @support  string $skuCode sku编码 
     * @support  string $otherRelateCode 更多编码 
     * @support  array $categoryIds 品类ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProducts (array $storeIds) {
        return self::getClass()->getProducts([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取商品
     *
     * @param  int $productId 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProduct (int $productId) {
        return self::getClass()->getProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取品类树
     *
     * @param  int $parentId 父级id [ require true ]
     * @param  int $depth 深度,代表几级分类 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryTree (int $parentId = 0, int $depth = 0, bool $showDeleted = false) {
        return self::getClass()->getCategoryTree([
            "parentId" => $parentId,
            "depth" => $depth,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 扫码获取商品
     *
     * @param  string $skuCode sku编码/更多编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductBySkuCode (string $skuCode) {
        return self::getClass()->getProductBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Retail\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Retail\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}