<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByOrderNoByParams(array $params)
 * @method submitByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method sendGiftCardPayDsConfirmPushByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method dingNotifyStaffEffectByParams(array $params)
 * @method closeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method getRetailPromotionOrderByParams(array $params)
 * @method getPromotionProductsByParams(array $params)
 * @method promotionDetailByParams(array $params)
 * @method finishExpressByParams(array $params)
 * @method batchFinishExpressByParams(array $params)
 * @method cancelExpressByParams(array $params)
 * @method batchCancelExpressByParams(array $params)
 * @method changeOrderStatusByParams(array $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $order_no 海马体订单号 
     * @support  int $user_id 用户ID 
     * @support  string $user_name 用户名 
     * @support  string $user_phone 用户手机号 
     * @support  string $user_sex 用户性别 
     * @support  string $user_birthday 用户生日 
     * @support  float $money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后金额) [Original type double] [ require true ]
     * @support  float $original_money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  int $input_staff_id 售出伙伴ID [ require true ]
     * @support  string $note 备注 
     * @support  bool $is_staff 是否是内部员工 
     * @support  bool $use_staff_discount 是否使用员工优惠 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑订单
     *
     * @support  string $order_no 订单号 
     * @support  int $id 订单ID 
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $user_name 用户名 
     * @support  string $user_phone 用户手机号 
     * @support  string $user_sex 用户性别 
     * @support  string $user_birthday 用户生日 
     * @support  float $money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后金额) [Original type double] [ require true ]
     * @support  float $original_money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $note 备注 
     * @support  string $from 订单来源（pc:管理端、mobile 预约端） 
     * @support  bool $is_staff 是否是内部员工 
     * @support  bool $use_staff_discount 是否使用员工优惠 
     * @support  int $input_staff_id 售出伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByOrderNo (string $order_no) {
        return self::getClass()->detailByOrderNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $page 页数 
     * @support  int $page_size 页内条数 
     * @support  string $user_phone 电话号码 
     * @support  string $paid_time_start 支付起始时间 
     * @support  string $paid_time_end 支付结束时间 
     * @support  string $user_name 用户姓名 
     * @support  string $order_no 订单号 
     * @support  string $pay_type 支付方式 
     * @support  string $status 状态 
     * @support  string $express_status 自提状态 
     * @support  string $status_list 状态列表 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * todo 增加权限设置
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardMoney 礼品卡支付金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGiftCardPayDsConfirmPush (int $id, float $giftCardMoney) {
        return self::getClass()->sendGiftCardPayDsConfirmPush([
            "id" => $id,
            "giftCardMoney" => $giftCardMoney,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  float $money 订单金额 [Original type double] [ require true ]
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @param  string $certificate 支付凭证 [ require true ]
     * @param  string $payment_time 对公打款时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, float $money, string $pay_type, string $payment_no = '', string $certificate = '', string $payment_time = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
            "certificate" => $certificate,
            "payment_time" => $payment_time,
        ]);
    }

    /**
     * 发送零售业绩钉钉消息)
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingNotifyStaffEffect (int $id) {
        return self::getClass()->dingNotifyStaffEffect([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_phone 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $order_no) {
        return self::getClass()->getIdByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单号获取订单下面买的产品
     *
     * @param  string $order_no 订单号 [ require true ]
     * @param  int $order_id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrder (string $order_no = NULL, int $order_id = NULL) {
        return self::getClass()->getProductsInOrder([
            "order_no" => $order_no,
            "order_id" => $order_id,
        ]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     *
     * @param  array $order_nos 订单号数组 [ require true ]
     * @param  array $order_ids 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrders (array $order_nos = [], array $order_ids = []) {
        return self::getClass()->getProductsInOrders([
            "order_nos" => $order_nos,
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * 获取零售产品促销订单信息
     *
     * @support  array $order_info 订单信息 [ require true ]
     * @support  bool $is_staff 是否是内部员工 
     * @support  bool $use_staff_discount 是否使用员工优惠 
     * @throws  \Exception
     * @return  array
     */
    public static function getRetailPromotionOrder () {
        return self::getClass()->getRetailPromotionOrder();
    }

    /**
     * 根据活动获取促销商品列表
     *
     * @support  int $promotion_id 活动ID [ require true ]
     * @support  string $name 订单信息 
     * @support  int $is_giveaway 是否是赠品:0 否 1 是 
     * @support  string $status 是否是上架商品: on 已上架商品 off 未上架商品 
     * @support  int $page 页数 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getPromotionProducts () {
        return self::getClass()->getPromotionProducts();
    }

    /**
     * 获取促销活动详情
     *
     * @support  int $promotion_id 活动ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function promotionDetail () {
        return self::getClass()->promotionDetail();
    }

    /**
     * 完成自提
     *
     * @param  int $itemId 订单itemId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishExpress (int $itemId) {
        return self::getClass()->finishExpress([
            "itemId" => $itemId,
        ]);
    }

    /**
     * 批量完成自提
     *
     * @param  array $itemIds 订单itemIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchFinishExpress (array $itemIds) {
        return self::getClass()->batchFinishExpress([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 撤销自提
     *
     * @param  int $itemId 订单itemId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelExpress (int $itemId) {
        return self::getClass()->cancelExpress([
            "itemId" => $itemId,
        ]);
    }

    /**
     * 批量撤销自提
     *
     * @param  array $itemIds 订单itemIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCancelExpress (array $itemIds) {
        return self::getClass()->batchCancelExpress([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 修改订单的状态
     *
     * @support  int $id id [ require true ]
     * @support  string $status 订单状态: submitted(未支付)，paid(已支付) 
     * @support  int $operateId 录入伙伴ID(后台操作时必须添加) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderStatus () {
        return self::getClass()->changeOrderStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}