<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method setPrintByParams(array $params)
 * @method detailByParams(array $params)
 * @method changeTakePhotoTypeByParams(array $params)
 * @method addPostNumByParams(array $params)
 * @method finishPrintByParams(array $params)
 * @method hookUserTakePhotoByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取在线看片列表
     *
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @support  string $phone 手机号 
     * @support  string $order_num 订单号 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 在线看片设置打印
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPrint () {
        return self::getClass()->setPrint();
    }

    /**
     * 在线看片详情
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (string $order_num) {
        return self::getClass()->detail([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 修改取片方式
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $take_type 取片方式 [ require true ]
     * @param  array $address 地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeTakePhotoType (string $order_num, string $take_type, array $address = []) {
        return self::getClass()->changeTakePhotoType([
            "order_num" => $order_num,
            "take_type" => $take_type,
            "address" => $address,
        ]);
    }

    /**
     * 标记发件
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $post_num 邮寄单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPostNum (string $order_num, string $post_num) {
        return self::getClass()->addPostNum([
            "order_num" => $order_num,
            "post_num" => $post_num,
        ]);
    }

    /**
     * 标记打印
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishPrint (string $serial_no) {
        return self::getClass()->finishPrint([
            "serial_no" => $serial_no,
        ]);
    }

    /**
     * todo 邮寄信息提醒伙伴
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @param  array $takeInfo 取片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookUserTakePhoto (string $orderNo, int $orgId, array $takeInfo) {
        return self::getClass()->hookUserTakePhoto([
            "orderNo" => $orderNo,
            "orgId" => $orgId,
            "takeInfo" => $takeInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}