<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setPrintByParams(array $params)
 * @method detailByParams(array $params)
 * @method changeTakePhotoTypeByParams(array $params)
 * @method addPostNumByParams(array $params)
 * @method hookUserTakePhotoByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 在线看片设置打印
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPrint (string $recordNo) {
        return self::getClass()->setPrint([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 在线看片详情
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (string $orderNum) {
        return self::getClass()->detail([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 修改取片方式
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $takeType 取片方式 [ require true ]
     * @param  array $postInfo 取片信息 [ require true ]
     * @support  string $postInfo.province 省 
     * @support  string $postInfo.city 市 
     * @support  string $postInfo.area 区 
     * @support  string $postInfo.detail 详细地址 
     * @support  string $postInfo.name 名字 
     * @support  string $postInfo.phone 电话 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeTakePhotoType (string $recordNo, string $takeType = NULL, array $postInfo = []) {
        return self::getClass()->changeTakePhotoType([
            "recordNo" => $recordNo,
            "takeType" => $takeType,
            "postInfo" => $postInfo,
        ]);
    }

    /**
     * 标记发件
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $postNum 邮递单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPostNum (string $recordNo, string $postNum) {
        return self::getClass()->addPostNum([
            "recordNo" => $recordNo,
            "postNum" => $postNum,
        ]);
    }

    /**
     * todo 邮寄信息提醒伙伴
     *
     * @param  string $outsideNo 订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @param  array $takeType 取片方式 [ require true ]
     * @param  int $photoCount 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookUserTakePhoto (string $outsideNo, int $orgId, array $takeType, int $photoCount) {
        return self::getClass()->hookUserTakePhoto([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
            "takeType" => $takeType,
            "photoCount" => $photoCount,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}