<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method storeStaffByParams(array $params)
 * @method staffPluralismStopByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取员工列表
     *
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $store_id) {
        return self::getClass()->list([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 根据分类获取门店成员列表
     *
     * @support  int $store_id 门店ID 
     * @support  string $staff_type 伙伴职位Alias 
     * @throws  \Exception
     * @return  array
     */
    public static function storeStaff () {
        return self::getClass()->storeStaff();
    }

    /**
     * 兼岗确认添加对应门店权限
     *
     * @param  int $pluralism_store_id 门店ID [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffPluralismStop (int $pluralism_store_id, int $staff_id) {
        return self::getClass()->staffPluralismStop([
            "pluralism_store_id" => $pluralism_store_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}