<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method chooseTypeByParams(array $params)
 * @method getTodayOrdersByParams(array $params)
 * @method getOrderAllPendingStatusByParams(array $params)
 */
class DingDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴信息[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 选择进入的身份类型[done]
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $staff_type 摄影师: cameraman,化妆师: dresser [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function chooseType (int $store_id, string $staff_type) {
        return self::getClass()->chooseType([
            "store_id" => $store_id,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * 获取当日订单列表[done]
     *
     * @support  string $phone 手机号 
     * @support  string $pending_status 无纸化订单状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayOrders () {
        return self::getClass()->getTodayOrders();
    }

    /**
     * 获取当前门店下所有订单的状态[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllPendingStatus () {
        return self::getClass()->getOrderAllPendingStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\NoPaper\DingDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\NoPaper\DingDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}