<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderAllPendingStatusByParams(array $params)
 * @method addReceptionistRecordByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method giveOrderToStaffInManageByParams(array $params)
 * @method getStaffWorkStatesByParams(array $params)
 * @method removeStaffHangStateByParams(array $params)
 * @method getProcessStaffByParams(array $params)
 * @method getDresserRemarkByParams(array $params)
 * @method changeStateByCloudByParams(array $params)
 * @method removeHangOrderByParams(array $params)
 * @method hangOrderByParams(array $params)
 * @method adjustQueueSortByParams(array $params)
 * @method assignStaffByParams(array $params)
 * @method removeAssignStaffByParams(array $params)
 * @method queryStoresByParams(array $params)
 * @method getCurrentProcessingStaffByParams(array $params)
 * @method returnToWaitByParams(array $params)
 * @method getCanTakeOrderStaffsByParams(array $params)
 * @method orderHasHiddenProductsByParams(array $params)
 * @method orderAvailableTakersByParams(array $params)
 * @method cronChangeToWaitingByParams(array $params)
 * @method getPhotographyMakeUpTimeByParams(array $params)
 * @method clearUnfinishedOrderNoPaperInfoByParams(array $params)
 * @method trafficStatisticsByParams(array $params)
 * @method getCurrentHangStaffsByParams(array $params)
 * @method getHangActionTimeoutStaffsByParams(array $params)
 * @method dingUsersWhenOrderHangingTimeOutByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前门店下所有订单的状态[done]
     *
     * @support  int $store_id 店铺id 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllPendingStatus () {
        return self::getClass()->getOrderAllPendingStatus();
    }

    /**
     * 前台签到排队 done
     *
     * @support  int $staff_id 员工id 
     * @support  int $order_id 订单id [ require true ]
     * @support  int $dresser_id 指定的化妆师id 
     * @support  int $cameraman_id 指定的摄影师id 
     * @support  int $second_retoucher_id 指定的看片师id 
     * @support  bool $skip_make_up 是否跳过化妆 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceptionistRecord () {
        return self::getClass()->addReceptionistRecord();
    }

    /**
     * 获取门店在当前等待队列队尾序号[done]
     *
     * @support  int $store_id 门店id 
     * @support  string $pending_status 类型(signed_in_queue/wait_make_up/wait_photography/wait_look_photo) 
     * @throws  \Exception
     * @return  int
     */
    public static function getLastQueueSort () {
        return self::getClass()->getLastQueueSort();
    }

    /**
     * 管理端分配订单给某人
     *
     * @support  string $staff_type 用户类型 [ require true ]
     * @support  int $to_staff_id 分配给某人 [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function giveOrderToStaffInManage () {
        return self::getClass()->giveOrderToStaffInManage();
    }

    /**
     * 获取伙伴当前工作状态[done]
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffWorkStates () {
        return self::getClass()->getStaffWorkStates();
    }

    /**
     * 解除挂起
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $staff_id staff id [ require true ]
     * @support  string $staff_type 伙伴类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHangState () {
        return self::getClass()->removeStaffHangState();
    }

    /**
     * 获取订单无纸化流程伙伴信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff (int $order_id) {
        return self::getClass()->getProcessStaff([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取化妆备注
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getDresserRemark () {
        return self::getClass()->getDresserRemark();
    }

    /**
     * 云图端结束摄影中状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStateByCloud (string $orderNum, string $remark = '') {
        return self::getClass()->changeStateByCloud([
            "orderNum" => $orderNum,
            "remark" => $remark,
        ]);
    }

    /**
     * 解除挂起的订单
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeHangOrder () {
        return self::getClass()->removeHangOrder();
    }

    /**
     * 挂起订单
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangOrder () {
        return self::getClass()->hangOrder();
    }

    /**
     * 调整订单排序
     *
     * @support  int $order_id order id [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustQueueSort () {
        return self::getClass()->adjustQueueSort();
    }

    /**
     * 指定化妆师或者摄影师
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $dresser_id 化妆师id 
     * @support  int $cameraman_id 摄影师id 
     * @support  int $second_retoucher_id 摄影师id 
     * @throws  \Exception
     * @return  array
     */
    public static function assignStaff () {
        return self::getClass()->assignStaff();
    }

    /**
     * 清除指派的化妆师或者摄影师
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $staff_type 伙伴类型 
     * @throws  \Exception
     * @return  array
     */
    public static function removeAssignStaff () {
        return self::getClass()->removeAssignStaff();
    }

    /**
     * [管]门店列表
     *
     * @param  string $classification_nums 区域id;用,隔开 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStores (string $classification_nums = '') {
        return self::getClass()->queryStores([
            "classification_nums" => $classification_nums,
        ]);
    }

    /**
     * 获取当前处理订单的伙伴
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentProcessingStaff () {
        return self::getClass()->getCurrentProcessingStaff();
    }

    /**
     * 退回等待状态
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToWait () {
        return self::getClass()->returnToWait();
    }

    /**
     * 获取可接单伙伴的信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanTakeOrderStaffs () {
        return self::getClass()->getCanTakeOrderStaffs();
    }

    /**
     * 订单是否存在下架产品
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderHasHiddenProducts () {
        return self::getClass()->orderHasHiddenProducts();
    }

    /**
     * 获取可接单的伙伴id
     *
     * @support  array $staff_ids 伙伴ids [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderAvailableTakers () {
        return self::getClass()->orderAvailableTakers();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronChangeToWaiting () {
        return self::getClass()->cronChangeToWaiting();
    }

    /**
     * 获取等待中订单的信息和时间
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographyMakeUpTime () {
        return self::getClass()->getPhotographyMakeUpTime();
    }

    /**
     * clearUnfinishedOrderNoPaperInfo
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearUnfinishedOrderNoPaperInfo () {
        return self::getClass()->clearUnfinishedOrderNoPaperInfo();
    }

    /**
     * 流量看板
     *
     * @support  array $store_ids 门店组 [ require true ]
     * @support  string $date 时间 
     * @throws  \Exception
     * @return  array
     */
    public static function trafficStatistics () {
        return self::getClass()->trafficStatistics();
    }

    /**
     * 获取当前挂起的用户
     *
     * @support  int $store_id 门店 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentHangStaffs () {
        return self::getClass()->getCurrentHangStaffs();
    }

    /**
     * 获取当前超过挂起时长限制的伙伴
     *
     * @support  int $store_id 门店 [ require true ]
     * @support  int $minutes 分钟数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHangActionTimeoutStaffs () {
        return self::getClass()->getHangActionTimeoutStaffs();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingUsersWhenOrderHangingTimeOut () {
        return self::getClass()->dingUsersWhenOrderHangingTimeOut();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}