<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method doRequestToNsByParams(array $params)
 * @method addInventoryTaskLogByParams(array $params)
 */
class TaskLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 执行记录里面的同步
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function doRequestToNs () {
        return self::getClass()->doRequestToNs();
    }

    /**
     * 盘点审核通过后,进行库存的同步操作
     *
     * @param  array $inventoryIds 盘点ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addInventoryTaskLog (array $inventoryIds) {
        return self::getClass()->addInventoryTaskLog([
            "inventoryIds" => $inventoryIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\TaskLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\TaskLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}