<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStockListByParams(array $params)
 * @method stockInByParams(array $params)
 * @method stockOutByParams(array $params)
 * @method cancelStockOutByParams(array $params)
 * @method stockSaleByParams(array $params)
 * @method stockTransferByParams(array $params)
 * @method stockTransferToStoreByParams(array $params)
 * @method getStockRecordByParams(array $params)
 * @method autoSyncStockByParams(array $params)
 * @method autoSyncFixedAssetByParams(array $params)
 * @method autoSyncSafetyStockByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 库存列表
     *
     * @support  string $locType 仓库 
     * @support  string $materialName 物料名称 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockList (int $page = 1, int $pageSize = 5) {
        return self::getClass()->getStockList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 入库
     *
     * @param  string $logisticsNumber 物流单号 [ require true ]
     * @param  int $materialSkuId 物料sku_id [Original type uint] [ require true ]
     * @param  int $locType 仓库 [Original type uint] [ require true ]
     * @param  int $count 数量 [Original type uint] [ require true ]
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockIn (string $logisticsNumber, int $materialSkuId, int $locType, int $count) {
        return self::getClass()->stockIn([
            "logisticsNumber" => $logisticsNumber,
            "materialSkuId" => $materialSkuId,
            "locType" => $locType,
            "count" => $count,
        ]);
    }

    /**
     * 出库
     *
     * @param  int $materialSkuId 物料sku_id [Original type uint] [ require true ]
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  int $count 数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockOut (int $materialSkuId, int $staffId, int $count) {
        return self::getClass()->stockOut([
            "materialSkuId" => $materialSkuId,
            "staffId" => $staffId,
            "count" => $count,
        ]);
    }

    /**
     * 出库撤销
     *
     * @param  int $materialSkuId 物料sku_id [Original type uint] [ require true ]
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @support  int $storeId 门店id [Original type uint] 
     * @param  string $locType 仓库 [ require true ]
     * @param  int $count 数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelStockOut (int $materialSkuId, int $staffId, string $locType, int $count) {
        return self::getClass()->cancelStockOut([
            "materialSkuId" => $materialSkuId,
            "staffId" => $staffId,
            "locType" => $locType,
            "count" => $count,
        ]);
    }

    /**
     * 销售
     *
     * @param  int $materialSkuId 物料sku_id [Original type uint] [ require true ]
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @support  int $storeId 门店id [Original type uint] 
     * @support  string $locType 仓库 
     * @param  int $count 数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockSale (int $materialSkuId, int $staffId, int $count) {
        return self::getClass()->stockSale([
            "materialSkuId" => $materialSkuId,
            "staffId" => $staffId,
            "count" => $count,
        ]);
    }

    /**
     * 门店内部的移库
     *
     * @param  int $materialSkuId 物料sku_id [Original type uint] [ require true ]
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  int $fromLocType 从?仓库出 [Original type uint] [ require true ]
     * @param  int $toLocType 往?仓库入 [Original type uint] [ require true ]
     * @param  int $count 数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockTransfer (int $materialSkuId, int $staffId, int $fromLocType, int $toLocType, int $count) {
        return self::getClass()->stockTransfer([
            "materialSkuId" => $materialSkuId,
            "staffId" => $staffId,
            "fromLocType" => $fromLocType,
            "toLocType" => $toLocType,
            "count" => $count,
        ]);
    }

    /**
     * 门店间的库存转移,ns调用,保存记录
     *
     * @param  array $params params [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockTransferToStore (array $params) {
        return self::getClass()->stockTransferToStore([
            "params" => $params,
        ]);
    }

    /**
     * 出入库记录查询
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $materialName 物料名称 
     * @support  string $staffId 员工工号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockRecord (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStockRecord([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 自动同步每个门店的库存数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSyncStock () {
        return self::getClass()->autoSyncStock();
    }

    /**
     * 自动同步每个门店的固定资产数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSyncFixedAsset () {
        return self::getClass()->autoSyncFixedAsset();
    }

    /**
     * 同步安全库存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSyncSafetyStock () {
        return self::getClass()->autoSyncSafetyStock();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}