<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method workNumberByParams(array $params)
 * @method getKpsWorkByParams(array $params)
 */
class WorkStatistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人工作看板
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  string $staff_type 员工岗位 
     * @support  string $staff_id 员工id 
     * @throws  \Exception
     * @return  array
     */
    public static function workNumber () {
        return self::getClass()->workNumber();
    }

    /**
     * 获取看片师工作量
     *
     * @support  string $start_time 查询开始时间 [ require true ]
     * @support  string $end_time 查询结束时间 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  array
     */
    public static function getKpsWork () {
        return self::getClass()->getKpsWork();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\WorkStatistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\WorkStatistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}