<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfStoreStreamQueueByParams(array $params)
 * @method getAllStoreStreamQueueByParams(array $params)
 */
class CloudStreamQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取本门店云端队列信息
     *
     * @support  string $orderNum 订单号 
     * @support  string $streamNum 流水号 
     * @support  string $userName 姓名 
     * @support  string $userPhone 手机号 
     * @support  string $state 流水状态 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfStoreStreamQueue () {
        return self::getClass()->getSelfStoreStreamQueue();
    }

    /**
     * 获取全国门店云端队列信息
     *
     * @support  string $orderNum 订单号 
     * @support  string $streamNum 流水号 
     * @support  string $userName 姓名 
     * @support  string $userPhone 手机号 
     * @support  string $state 流水状态 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStoreStreamQueue () {
        return self::getClass()->getAllStoreStreamQueue();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\CloudStreamQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\CloudStreamQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}