<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrderByParams(array $params)
 * @method getOrderTakeTimeByParams(array $params)
 * @method pushOrderToCameramanByParams(array $params)
 * @method getOrderOnlineListByParams(array $params)
 * @method revokeCloudStreamByParams(array $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method submitToCloudByParams(array $params)
 * @method allStreamSubmitByParams(array $params)
 * @method getPhotographicNumByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method revokeOrderByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method createCloudProductByParams(array $params)
 * @method enableCloudProductByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method needReuploadByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄订单查询
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $user_name 顾客姓名 [ require true ]
     * @param  string $user_phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrder (string $order_num = '', string $user_name = '', string $user_phone = '') {
        return self::getClass()->searchOrder([
            "order_num" => $order_num,
            "user_name" => $user_name,
            "user_phone" => $user_phone,
        ]);
    }

    /**
     * 获取订单取片时间
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderTakeTime (int $order_id) {
        return self::getClass()->getOrderTakeTime([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 订单添加至摄影师
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushOrderToCameraman (int $order_id) {
        return self::getClass()->pushOrderToCameraman([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 摄影师接单列表查询
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnlineList () {
        return self::getClass()->getOrderOnlineList();
    }

    /**
     * 撤回照片(流水维度)
     *
     * @param  int $cloud_stream_id 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeCloudStream (int $cloud_stream_id) {
        return self::getClass()->revokeCloudStream([
            "cloud_stream_id" => $cloud_stream_id,
        ]);
    }

    /**
     * 云端流水详情
     *
     * @param  int $cloud_stream_id 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo (int $cloud_stream_id) {
        return self::getClass()->getCloudStreamInfo([
            "cloud_stream_id" => $cloud_stream_id,
        ]);
    }

    /**
     * 提交至云端
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $item_id 订单id [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  int $service_id 服务id 
     * @support  array $retouch_claim 修片要求 
     * @support  string $take_time 取片时间 [ require true ]
     * @support  array $photo_data 照片信息 [ require true ]
     * @support  string $photography_note 摄影备注 
     * @support  string $retouch_note 修片备注 [ require true ]
     * @support  bool $reupload 是否重传 
     * @throws  \Exception
     * @return  array
     */
    public static function submitToCloud () {
        return self::getClass()->submitToCloud();
    }

    /**
     * 全部流水确认上传
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allStreamSubmit (int $order_id) {
        return self::getClass()->allStreamSubmit([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取摄影数量
     *
     * @param  int $product_id 产品id [ require true ]
     * @param  int $service_id 服务id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getPhotographicNum (int $product_id, int $service_id = 0) {
        return self::getClass()->getPhotographicNum([
            "product_id" => $product_id,
            "service_id" => $service_id,
        ]);
    }

    /**
     * 获取订单历史上传记录详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryInfo (int $order_id) {
        return self::getClass()->getHistoryInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  string $order_num 订单号 
     * @support  string $user_name 顾客姓名 
     * @support  string $user_phone 顾客手机号 
     * @support  bool $search_without_staff 不根据伙伴查询 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 撤回照片(订单维度)
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeOrder (int $order_id) {
        return self::getClass()->revokeOrder([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取Host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 创建云端产品
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createCloudProduct (int $product_id) {
        return self::getClass()->createCloudProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 启用云端产品
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableCloudProduct (int $product_id) {
        return self::getClass()->enableCloudProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 批量获取流水详情(通过流水id)
     *
     * @support  array $cloud_stream_ids 流水ids 
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfoByIds () {
        return self::getClass()->batchGetStreamInfoByIds();
    }

    /**
     * 选择重传产品
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $item_id 子订单产品项id [ require true ]
     * @param  int $product_id 产品id [ require true ]
     * @param  int $service_id 服务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function needReupload (int $order_id, int $item_id, int $product_id, int $service_id = NULL) {
        return self::getClass()->needReupload([
            "order_id" => $order_id,
            "item_id" => $item_id,
            "product_id" => $product_id,
            "service_id" => $service_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}