<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductByParams(array $params)
 * @method getStoreProductByParams(array $params)
 */
class ProductTree {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 全部产品列表
     *
     * @support  int $category_id 类目id 
     * @support  string $name 产品名(模糊查询) 
     * @support  string $full_name 产品全名(模糊查询) 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $module 产品所属模块 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct();
    }

    /**
     * 获取门店产品树
     *
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreProduct () {
        return self::getClass()->getStoreProduct();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\ProductTree');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\ProductTree');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}