<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method paidByParams(array $params)
 * @method cancelByParams(array $params)
 * @method reviewByParams(array $params)
 * @method balanceEntryByParams(array $params)
 * @method getPhotoOrdersByParams(array $params)
 * @method deleteOrderItemByParams(array $params)
 */
class GroupOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 团购订单列表
     *
     * @support  string $business_name 企业名称 
     * @support  string $user_name 联系人 
     * @support  string $user_phone 手机号 
     * @support  array $order_ids 订单ids 
     * @support  array $order_nos 订单号 
     * @support  string $status 订单状态 
     * @support  bool $is_private_pay 是否垫付(-1:非垫付，1：垫付) 
     * @support  bool $is_installment 是否分期(-1:全款，1：分期) 
     * @support  string $installment_status 分期付款状态 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 创建订单
     *
     * @support  string $business_name 企业名称 [ require true ]
     * @support  string $user_name 联系人 [ require true ]
     * @support  string $user_phone 手机号 [ require true ]
     * @support  array $detail 团购产品信息 
     * @support  string $note 预约信息备注 
     * @support  bool $is_installment 是否分期 
     * @support  bool $is_private_pay 是否垫付（私人付款） 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $pay_money 实付金额 [Original type double] 
     * @support  float $discount 折扣 [Original type double] 
     * @support  float $down_payment_money 首付金额 [Original type double] 
     * @support  float $balance_payment_money 尾款金额 [Original type double] 
     * @support  string $private_user_name 垫付人姓名 
     * @support  string $private_user_phone 垫付人电话 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单支付（全款与首款）
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  string $payment_no 支付流水号 
     * @support  array $certificates 支付凭证 
     * @support  string $type 付款类型（全款，首款，尾款） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paid () {
        return self::getClass()->paid();
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id) {
        return self::getClass()->cancel([
            "id" => $id,
        ]);
    }

    /**
     * 订单审核
     *
     * @param  int $pay_id 支付id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function review (int $pay_id) {
        return self::getClass()->review([
            "pay_id" => $pay_id,
        ]);
    }

    /**
     * 支付尾款
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  float $money 尾款金额 [Original type double] [ require true ]
     * @support  string $payment_no 支付流水号 
     * @support  bool $is_change 尾款是否变动 
     * @support  array $detail 变动详情 
     * @support  array $certificates 支付凭证 
     * @throws  \Exception
     * @return  array
     */
    public static function balanceEntry () {
        return self::getClass()->balanceEntry();
    }

    /**
     * 获取关联拍摄订单
     *
     * @support  int $group_order_id 团购订单id [ require true ]
     * @support  array $order_ids 订单ids 
     * @support  array $order_nos 订单ids 
     * @support  string $user_name 下单用户 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoOrders () {
        return self::getClass()->getPhotoOrders();
    }

    /**
     * 删除预约产品
     *
     * @support  int $id 预约产品信息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrderItem () {
        return self::getClass()->deleteOrderItem();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\GroupOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\GroupOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}