<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStockCountByParams(array $params)
 * @method submitByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 */
class Inventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据类型获取物料数量
     *
     * @param  string $locType 仓库类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockCount (string $locType) {
        return self::getClass()->getStockCount([
            "locType" => $locType,
        ]);
    }

    /**
     * 提交盘点结果
     *
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  string $type 盘点类型 [ require true ]
     * @param  array $materialInfo 物料信息 [ require true ]
     * @param  string $status 状态是否一致consistent [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $staffId, string $type, array $materialInfo, string $status = 'consistent') {
        return self::getClass()->submit([
            "staffId" => $staffId,
            "type" => $type,
            "materialInfo" => $materialInfo,
            "status" => $status,
        ]);
    }

    /**
     * 盘点列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $type 类型 
     * @support  string $staffId 操作人 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点详情
     *
     * @param  int $inventoryId 盘点记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $inventoryId) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Inventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Inventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}