<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createIncomeByParams(array $params)
 * @method createExpendByParams(array $params)
 * @method incomeListByParams(array $params)
 * @method expendListByParams(array $params)
 * @method certificateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method checkByParams(array $params)
 * @method goodsByParams(array $params)
 * @method financeFixTurnoverByParams(array $params)
 */
class Turnover {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 线下收入录入
     *
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  int $num 数量 
     * @support  int $seller_id 售出人 
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  int $goods_id 商品id [ require true ]
     * @support  string $type 类型[收入/支出流水] [ require true ]
     * @support  string $pay_time 支付时间 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function createIncome () {
        return self::getClass()->createIncome();
    }

    /**
     * 线下支出录入
     *
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  int $goods_id 商品id [ require true ]
     * @support  string $type 类型[收入/支出流水] [ require true ]
     * @support  string $duty_person 收款人 [ require true ]
     * @support  string $note 备注 
     * @support  array $certificates 凭证 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createExpend () {
        return self::getClass()->createExpend();
    }

    /**
     * 线下收入流水查询
     *
     * @support  int $store_id 门店id 
     * @support  string $type 收入/支出 
     * @support  int $operate_id 操作人id 
     * @support  string $pay_type 支付类型 
     * @support  string $start_time 开始时间 [ require true ]
     * @support  string $end_time 结束时间 [ require true ]
     * @support  string $goods_id 商品id 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function incomeList () {
        return self::getClass()->incomeList();
    }

    /**
     * 线下支出流水查询
     *
     * @support  int $store_id 门店id 
     * @support  string $type 收入/支出 
     * @support  int $operate_id 操作人id 
     * @support  string $pay_type 支付类型 
     * @support  string $start_time 开始时间 [ require true ]
     * @support  string $end_time 结束时间 [ require true ]
     * @support  string $goods_id 商品id 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function expendList () {
        return self::getClass()->expendList();
    }

    /**
     * 查看凭证
     *
     * @support  int $_id 流水单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function certificate () {
        return self::getClass()->certificate();
    }

    /**
     * 删除流水
     *
     * @support  int $_id 流水单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 审核操作
     *
     * @support  int $_id 流水单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function check () {
        return self::getClass()->check();
    }

    /**
     * 获取商品列表
     *
     * @support  string $type 收入/支出类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function goods () {
        return self::getClass()->goods();
    }

    /**
     * 财务流水修正
     *
     * @support  int $type 修改类型 1-订单支付方式,2-DS支付方式,3-删除DS [ require true ]
     * @support  int $order_id 订单ID 
     * @support  int $ds_id 订单二销ID 
     * @support  string $pay_type 支付方式 
     * @throws  \Exception
     * @return  array
     */
    public static function financeFixTurnover () {
        return self::getClass()->financeFixTurnover();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Turnover');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Turnover');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}