<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method reviewByParams(array $params)
 * @method bindSecondRetoucherByParams(array $params)
 * @method newStreamNotifyByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method historyByParams(array $params)
 * @method getMyReviewByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $order_num 订单号 
     * @support  string $name 姓名 
     * @support  string $phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 订单详情
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 通过审核
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  string $score 评价 [ require true ]
     * @support  array $photo 照片 
     * @support  string $note 评语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function review () {
        return self::getClass()->review();
    }

    /**
     * 绑定看片师
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSecondRetoucher () {
        return self::getClass()->bindSecondRetoucher();
    }

    /**
     * (论询)新流水通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function newStreamNotify () {
        return self::getClass()->newStreamNotify();
    }

    /**
     * 发送看片通知
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 历史列表
     *
     * @support  string $order_num 订单号 
     * @support  string $phone 手机号 
     * @support  string $name 姓名 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function history () {
        return self::getClass()->history();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReview () {
        return self::getClass()->getMyReview();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}