<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $user_phone 手机号 
     * @support  string $user_name 姓名 
     * @support  string $order_no 订单号 
     * @support  array $status 订单状态 
     * @support  array $pending_status 无纸化订单状态 
     * @support  int $store_id 门店ids [ require true ]
     * @support  string $picture_online_status 在线看片状态 
     * @support  bool $today_shooting 是否是当日拍摄 
     * @support  bool $looking_photo 是否是看片 
     * @support  int $page 页数 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}