<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderListByParams(array $params)
 * @method getOrderAllPendingStatusByParams(array $params)
 * @method addReceptionistRecordByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method giveOrderToStaffInManageByParams(array $params)
 * @method getStaffWorkStatesByParams(array $params)
 * @method removeStaffHangStateByParams(array $params)
 * @method cronChangeToWaitingByParams(array $params)
 * @method getProcessStaffByParams(array $params)
 * @method getDresserRemarkByParams(array $params)
 * @method getLastQueueSortOldByParams(array $params)
 * @method changeStateByCloudByParams(array $params)
 * @method cronAdjustAbnormalSelectStatusByParams(array $params)
 * @method queryStoreEfficiencyByParams(array $params)
 * @method queryStoresByParams(array $params)
 * @method getOrderStatesWithCountByParams(array $params)
 * @method sendCodeByParams(array $params)
 * @method queryAreasByParams(array $params)
 * @method queryProductsByParams(array $params)
 * @method removeHangOrderByParams(array $params)
 * @method hangOrderByParams(array $params)
 * @method adjustQueueSortByParams(array $params)
 * @method assignStaffByParams(array $params)
 * @method removeAssignStaffByParams(array $params)
 * @method getCurrentProcessingStaffByParams(array $params)
 * @method returnToWaitByParams(array $params)
 * @method kpsSignInByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $mobile 手机号 
     * @support  string $user_name 姓名 
     * @support  string $order_num 订单号 
     * @support  array $status 订单状态 
     * @support  array $pending_status 无纸化订单状态 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  array $store_ids 门店ids [ require true ]
     * @support  string $picture_online_status 在线看片状态 
     * @support  string $status_auto 自动判断类型, 关闭、今日拍摄自动判断传入参数，进行对应的设置, close、today_shooting。(嫌麻烦的可以使用这个) 
     * @param  int $page 页数 [ require true ]
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList (int $page = 1) {
        return self::getClass()->getOrderList([
            "page" => $page,
        ]);
    }

    /**
     * 获取当前门店下所有订单的状态[done]
     *
     * @param  int $store_id 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllPendingStatus (int $store_id) {
        return self::getClass()->getOrderAllPendingStatus([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 前台签到排队[done]
     *
     * @support  int $staff_id 员工id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  int $dresser_id 指定的化妆师id 
     * @support  int $cameraman_id 指定的摄影师id 
     * @support  bool $skip_make_up 是否跳过化妆 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceptionistRecord () {
        return self::getClass()->addReceptionistRecord();
    }

    /**
     * 获取门店在当前等待队列队尾序号[done]
     *
     * @support  int $store_id 门店id 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSort () {
        return self::getClass()->getLastQueueSort();
    }

    /**
     * 管理端分配订单给某人
     *
     * @support  string $staff_type 用户类型 [ require true ]
     * @support  int $to_staff_id 分配给某人 [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function giveOrderToStaffInManage () {
        return self::getClass()->giveOrderToStaffInManage();
    }

    /**
     * 获取伙伴当前工作状态[done]
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffWorkStates () {
        return self::getClass()->getStaffWorkStates();
    }

    /**
     * 解除挂起
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $staff_id staff id [ require true ]
     * @support  string $staff_type 伙伴类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHangState () {
        return self::getClass()->removeStaffHangState();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronChangeToWaiting () {
        return self::getClass()->cronChangeToWaiting();
    }

    /**
     * 获取订单无纸化流程伙伴信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff (int $order_id) {
        return self::getClass()->getProcessStaff([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取化妆备注
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getDresserRemark () {
        return self::getClass()->getDresserRemark();
    }

    /**
     * 获取门店在当前等待队列队尾序号
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSortOld (int $orderId, string $type) {
        return self::getClass()->getLastQueueSortOld([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * 云图端结束摄影中状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $comment 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStateByCloud (string $orderNum, string $comment = '') {
        return self::getClass()->changeStateByCloud([
            "orderNum" => $orderNum,
            "comment" => $comment,
        ]);
    }

    /**
     * 定时清理伙伴选片状态异常订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronAdjustAbnormalSelectStatus () {
        return self::getClass()->cronAdjustAbnormalSelectStatus();
    }

    /**
     * [管]门店效率查询
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  int $area_id 区域id 
     * @support  int $store_id 门店id 
     * @support  int $product_id 产品id 
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStoreEfficiency (int $page = 1, int $page_size = 10) {
        return self::getClass()->queryStoreEfficiency([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * [管]门店列表
     *
     * @param  string $classification_nums 区域id;用,隔开 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStores (string $classification_nums = '') {
        return self::getClass()->queryStores([
            "classification_nums" => $classification_nums,
        ]);
    }

    /**
     * 获取带数量的订单状态列表
     *
     * @param  int $store_id 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStatesWithCount (int $store_id) {
        return self::getClass()->getOrderStatesWithCount([
            "store_id" => $store_id,
        ]);
    }

    /**
     * [管]订单绑定发送验证码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCode (string $phone, string $order_num) {
        return self::getClass()->sendCode([
            "phone" => $phone,
            "order_num" => $order_num,
        ]);
    }

    /**
     * [管]门店区域列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function queryAreas () {
        return self::getClass()->queryAreas();
    }

    /**
     * [管]产品列表
     *
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryProducts () {
        return self::getClass()->queryProducts();
    }

    /**
     * 解除挂起的订单
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeHangOrder () {
        return self::getClass()->removeHangOrder();
    }

    /**
     * 挂起订单
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangOrder () {
        return self::getClass()->hangOrder();
    }

    /**
     * 调整订单排序
     *
     * @support  int $order_id order id [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustQueueSort () {
        return self::getClass()->adjustQueueSort();
    }

    /**
     * 指定化妆师或者摄影师
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $dresser_id 化妆师id 
     * @support  int $cameraman_id 摄影师id 
     * @throws  \Exception
     * @return  array
     */
    public static function assignStaff () {
        return self::getClass()->assignStaff();
    }

    /**
     * 清除指派的化妆师或者摄影师
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $staff_type 伙伴类型 
     * @throws  \Exception
     * @return  array
     */
    public static function removeAssignStaff () {
        return self::getClass()->removeAssignStaff();
    }

    /**
     * 获取当前处理订单的伙伴
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentProcessingStaff () {
        return self::getClass()->getCurrentProcessingStaff();
    }

    /**
     * 退回等待状态
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToWait () {
        return self::getClass()->returnToWait();
    }

    /**
     * 订单看片签到
     *
     * @support  int $order_id 订单id 
     * @support  int $second_retoucher_id 看片师id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function kpsSignIn () {
        return self::getClass()->kpsSignIn();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\NoPaper\NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\NoPaper\NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}