<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getStreamListByStaffByParams(array $params)
 * @method batchUploadByParams(array $params)
 * @method uploadByParams(array $params)
 * @method saveSeeTypeByParams(array $params)
 * @method takeStreamByParams(array $params)
 * @method getStreamCountByParams(array $params)
 * @method recordUpdateByParams(array $params)
 * @method updateStreamStatusByParams(array $params)
 * @method checkIMUserByParams(array $params)
 * @method autoSendReduceByParams(array $params)
 */
class OnlinePhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取线上看片列表
     *
     * @support  string $order_num 订单号 
     * @support  string $name 姓名 
     * @support  string $phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取看片师已经接的流水
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamListByStaff () {
        return self::getClass()->getStreamListByStaff();
    }

    /**
     * 批量上传照片
     *
     * @support  array $photos 照片数组[[&#039;photo_id&#039; =&gt; 1, &#039;path&#039; =&gt; &#039;www&#039;,],[&#039;photo_id&#039; =&gt; 2, &#039;path&#039; =&gt; &#039;www2&#039;,]] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpload () {
        return self::getClass()->batchUpload();
    }

    /**
     * 看片师上传照片信息
     *
     * @support  int $photo_id 照片id 
     * @support  string $path 照片地址 
     * @throws  \Exception
     * @return  array
     */
    public static function upload () {
        return self::getClass()->upload();
    }

    /**
     * 选择看片方式
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  string $watch_type 看片方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSeeType () {
        return self::getClass()->saveSeeType();
    }

    /**
     * 看片师接单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeStream () {
        return self::getClass()->takeStream();
    }

    /**
     * 获取流水数量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStreamCount () {
        return self::getClass()->getStreamCount();
    }

    /**
     * 音频反馈记录更新
     *
     * @support  int $record_id 记录id [ require true ]
     * @support  array $voice 声音数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recordUpdate () {
        return self::getClass()->recordUpdate();
    }

    /**
     * 更新流水状态
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStreamStatus () {
        return self::getClass()->updateStreamStatus();
    }

    /**
     * 获取腾讯im配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function checkIMUser () {
        return self::getClass()->checkIMUser();
    }

    /**
     * 自动发送次数-1
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendReduce () {
        return self::getClass()->autoSendReduce();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\OnlinePhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\OnlinePhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}