<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Photo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryWaitReviewListByParams(array $params)
 * @method bindCheckerByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method reviewByParams(array $params)
 * @method getCheckerUnReadStreamCountByParams(array $params)
 * @method readCountByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method CronCheckAndRemoveUnReviewOrderByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method readyWorkByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method hookCloudFinishStreamByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取待审核订单列表
     *
     * @support  string $order_num 订单号 
     * @support  string $user_name 姓名 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitReviewList () {
        return self::getClass()->queryWaitReviewList();
    }

    /**
     * 绑定审核人id
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 订单详情
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * 提交审核
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  int $score 评价 [ require true ]
     * @support  array $photo 照片 
     * @support  string $note 评语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function review () {
        return self::getClass()->review();
    }

    /**
     * 获取未读流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCheckerUnReadStreamCount () {
        return self::getClass()->getCheckerUnReadStreamCount();
    }

    /**
     * 已读流水接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function readCount () {
        return self::getClass()->readCount();
    }

    /**
     * 发送看片通知
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 历史列表
     *
     * @support  string $order_num 订单号 
     * @support  string $user_phone 手机号 
     * @support  string $user_name 姓名 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory();
    }

    /**
     * (定时任务:)修改未审核完成的流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function CronCheckAndRemoveUnReviewOrder () {
        return self::getClass()->CronCheckAndRemoveUnReviewOrder();
    }

    /**
     * (首次登录:)提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 看片师准备
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function readyWork () {
        return self::getClass()->readyWork();
    }

    /**
     * 看片师已接订单[只取一单]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnline () {
        return self::getClass()->getOrderOnline();
    }

    /**
     * 获取看片师订单详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (int $order_id) {
        return self::getClass()->getOrderInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取看片师订单历史上传记录详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryInfo (int $order_id) {
        return self::getClass()->getHistoryInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  string $order_num 订单号 
     * @support  string $user_name 顾客姓名 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 提交最终成片
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  array $photo_data 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitFinalPhoto (string $stream_num, array $photo_data) {
        return self::getClass()->submitFinalPhoto([
            "stream_num" => $stream_num,
            "photo_data" => $photo_data,
        ]);
    }

    /**
     * 接收云端流水完成事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudFinishStream (string $stream_num) {
        return self::getClass()->hookCloudFinishStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Photo\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}