<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method inputByParams(array $params)
 * @method detailByParams(array $params)
 * @method canSaleCardListByParams(array $params)
 * @method allByParams(array $params)
 */
class ProductCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品卡订单列表
     *
     * @support  string $phone 手机号 
     * @support  string $user_name 用户名 
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $pay_type 支付方式 
     * @support  int $page 分页 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品卡订单录入
     *
     * @support  string $user_name 用户名 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 性别 [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  float $ori_money 原价金额 [Original type unsignedDouble] [ require true ]
     * @support  float $pay_money 实付 [Original type double] [ require true ]
     * @support  array $extend 拓展信息 
     * @support  array $card_ids 卡片ids [Original type array&lt;uint&gt;] [ require true ]
     * @support  string $type 卡类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function input () {
        return self::getClass()->input();
    }

    /**
     * 产品卡订单详情
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 可售产品卡列表
     *
     * @support  int $store_id 门店id [Original type uint] 
     * @support  int $template_id 模板ID 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function canSaleCardList () {
        return self::getClass()->canSaleCardList();
    }

    /**
     * 获取产品卡模板列表(所有)
     *
     * @support  string $name 优惠名称 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\ProductCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\ProductCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}