<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method chooseTypeByParams(array $params)
 */
class DingDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴信息[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 选择进入的身份类型[done]
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $staff_type 摄影师: cameraman,化妆师: dresser [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseType (int $store_id, string $staff_type) {
        return self::getClass()->chooseType([
            "store_id" => $store_id,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\NoPaper\DingDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\NoPaper\DingDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}