<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method snByParams(array $params)
 * @method staffByParams(array $params)
 * @method storeByParams(array $params)
 * @method orderByParams(array $params)
 * @method editByParams(array $params)
 * @method getSnDetailByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询sn问卷数据
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function sn () {
        return self::getClass()->sn();
    }

    /**
     * 个人nps数据统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $staff_id 员工id 
     * @support  int $store_id 门店id [ require true ]
     * @support  string $staff_type 岗位类型 
     * @support  int $score 评价得分 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 门店nps数据统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  int $score 评分范围 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 获取订单nps详情
     *
     * @support  string $order_num 订单编号 
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function order () {
        return self::getClass()->order();
    }

    /**
     * nps修改
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $nps_all 总评分 
     * @support  int $nps_receptionist 门市客服评分 
     * @support  int $nps_cameraman 摄影师评分 
     * @support  int $nps_retoucher 看片师评分 
     * @support  int $nps_dresser 化妆师评分 
     * @throws  \Exception
     * @return  array
     */
    public static function edit () {
        return self::getClass()->edit();
    }

    /**
     * 获取sn详情
     *
     * @param  int $sn_id snId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSnDetail (int $sn_id) {
        return self::getClass()->getSnDetail([
            "sn_id" => $sn_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}