<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method chooseTypeByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method completeOrderProductByParams(array $params)
 * @method changeProductStatusByParams(array $params)
 * @method continueToMakeUpByParams(array $params)
 * @method goSelectPhotoByParams(array $params)
 * @method allProductByParams(array $params)
 * @method productDetailByParams(array $params)
 * @method orderNoteByParams(array $params)
 */
class DingDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴信息[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 选择进入的身份类型[done]
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $staff_type 摄影师: sys,化妆师: hzs [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseType (int $store_id, string $staff_type) {
        return self::getClass()->chooseType([
            "store_id" => $store_id,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDetail (int $order_id) {
        return self::getClass()->orderDetail([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 完成当前产品
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $status 完成状态 [ require true ]
     * @param  array $product_info 产品信息(默认完成当前产品，需更换为其他产品时填写) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeOrderProduct (int $order_id, string $status, array $product_info = []) {
        return self::getClass()->completeOrderProduct([
            "order_id" => $order_id,
            "status" => $status,
            "product_info" => $product_info,
        ]);
    }

    /**
     * 化妆完成产品状态至摄影
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $product_info 产品信息 [ require true ]
     * @param  bool $is_master 是否主化妆师 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeProductStatus (int $order_id, bool $is_master, array $product_info = []) {
        return self::getClass()->changeProductStatus([
            "order_id" => $order_id,
            "is_master" => $is_master,
            "product_info" => $product_info,
        ]);
    }

    /**
     * 继续化妆
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $product_info 产品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function continueToMakeUp (int $order_id, array $product_info = []) {
        return self::getClass()->continueToMakeUp([
            "order_id" => $order_id,
            "product_info" => $product_info,
        ]);
    }

    /**
     * 去选片
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $product_info 产品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function goSelectPhoto (int $order_id, array $product_info) {
        return self::getClass()->goSelectPhoto([
            "order_id" => $order_id,
            "product_info" => $product_info,
        ]);
    }

    /**
     * 门店所有产品
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allProduct (int $store_id) {
        return self::getClass()->allProduct([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 门店产品详情
     *
     * @support  int $product_id 产品ID [ require true ]
     * @support  int $store_id 门店Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productDetail () {
        return self::getClass()->productDetail();
    }

    /**
     * 修改订单备注
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $note 订单备注 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderNote () {
        return self::getClass()->orderNote();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\DingDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\DingDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}